/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1764", name="Identical expressions should not be used on both sides of a binary operator", priority=Priority.CRITICAL, tags={"bug", "cert"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class IdenticalExpressionOnBinaryOperatorCheck
extends BaseTreeVisitor {
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.MULTIPLY, Tree.Kind.PLUS, Tree.Kind.ASSIGNMENT}) && SyntacticEquivalence.areEquivalent((Tree)tree.leftOperand(), (Tree)tree.rightOperand()) && this.isExcluded(tree)) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, "Identical sub-expressions on both sides of operator \"" + tree.operator().text() + "\"");
        }
        super.visitBinaryExpression(tree);
    }

    private boolean isExcluded(BinaryExpressionTree tree) {
        return !IdenticalExpressionOnBinaryOperatorCheck.isOneOntoOneShifting(tree) && !IdenticalExpressionOnBinaryOperatorCheck.isPotentialNanComparison(tree);
    }

    private static boolean isPotentialNanComparison(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO}) && (tree.leftOperand().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.IDENTIFIER, Tree.Kind.BRACKET_MEMBER_EXPRESSION, Tree.Kind.DOT_MEMBER_EXPRESSION}) || tree.leftOperand() instanceof UnaryExpressionTree);
    }

    private static boolean isOneOntoOneShifting(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.LEFT_SHIFT}) && tree.leftOperand().is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && "1".equals(((LiteralTree)tree.leftOperand()).value());
    }
}

