/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.io.Closeables;
import com.sonar.sslr.api.AstNode;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="MissingNewlineAtEndOfFile", name="Files should contain an empty new line at the end", priority=Priority.MINOR, tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class MissingNewlineAtEndOfFileCheck
extends SquidCheck<LexerlessGrammar> {
    public void visitFile(AstNode astNode) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.getContext().getFile(), "r");
            if (!MissingNewlineAtEndOfFileCheck.endsWithNewline(randomAccessFile)) {
                this.getContext().createFileViolation((CodeCheck)this, "Add a new line at the end of this file.", new Object[0]);
            }
        }
        catch (IOException e) {
            try {
                throw new SonarException((Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(randomAccessFile);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)randomAccessFile);
    }

    private static boolean endsWithNewline(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile.length() < 1L) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - 1L);
        byte[] chars = new byte[1];
        if (randomAccessFile.read(chars) < 1) {
            return false;
        }
        String ch = new String(chars);
        return "\n".equals(ch) || "\r".equals(ch);
    }
}

