/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.Trivia;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.ast.resolve.type.FunctionTree;
import org.sonar.javascript.ast.resolve.type.FunctionType;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2999", name="\"new\" operators should be used with functions", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class NewOperatorMisusageCheck
extends BaseTreeVisitor {
    public static final boolean CONSIDER_JSDOC = false;
    @RuleProperty(key="considerJSDoc", description="Consider only functions with @constructor tag as constructor functions", defaultValue="false")
    public boolean considerJSDoc = false;

    public void visitNewExpression(NewExpressionTree tree) {
        ExpressionTree expression = tree.expression();
        if (!expression.types().isEmpty() && this.isNotConstructor((Set<Type>)expression.types())) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)expression, String.format("Replace %s with a constructor function.", CheckUtils.asString((Tree)expression)));
        }
        super.visitNewExpression(tree);
    }

    private boolean isNotConstructor(Set<Type> types) {
        boolean isConstructor = false;
        boolean isUnknown = false;
        for (Type t : types) {
            if (t.kind() == Type.Kind.FUNCTION) {
                isConstructor = this.considerJSDoc ? NewOperatorMisusageCheck.hasJSDocAnnotation(((FunctionType)t).functionTree()) : true;
                continue;
            }
            if (t.kind() != Type.Kind.UNKNOWN) continue;
            isUnknown = true;
        }
        return !isConstructor && !isUnknown;
    }

    private static boolean hasJSDocAnnotation(FunctionTree funcDec) {
        for (Trivia trivia : ((JavaScriptTree)funcDec).getToken().getTrivia()) {
            if (!trivia.toString().contains("@constructor") && !trivia.toString().contains("@class")) continue;
            return true;
        }
        return false;
    }
}

