/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="NonEmptyCaseWithoutBreak", name="Switch cases should end with an unconditional \"break\" statement", priority=Priority.CRITICAL, tags={"cert", "cwe", "misra", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class NonEmptyCaseWithoutBreakCheck
extends BaseTreeVisitor {
    public void visitSwitchStatement(SwitchStatementTree tree) {
        LinkedList cases = new LinkedList(tree.cases());
        cases.remove(cases.size() - 1);
        for (SwitchClauseTree switchClauseTree : cases) {
            List statements = switchClauseTree.statements();
            if (statements.isEmpty() || ((StatementTree)Iterables.getLast((Iterable)statements)).is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.THROW_STATEMENT})) continue;
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)switchClauseTree, "Last statement in this switch-clause should be an unconditional break.");
        }
        super.visitSwitchStatement(tree);
    }
}

