/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.SyntacticEquivalence;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.AstTreeVisitorContext;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1697", name="Short-circuit logic should be used to prevent null pointer dereferences in conditionals", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class NullDereferenceInConditionalCheck
extends BaseTreeVisitor {
    private static final String MESSAGE_FORMAT = "Either reverse the equality operator in the \"%s\" null test, or reverse the logical operator that follows it.";

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (this.isAndWithEqualToNull(tree) || this.isOrWithNonEqualToNull(tree)) {
            BinaryExpressionTree leftOperand = (BinaryExpressionTree)this.removeParenthesis(tree.leftOperand());
            ExpressionTree expression = this.removeParenthesis(this.getNonNullLiteralOperand(leftOperand));
            tree.rightOperand().accept((TreeVisitor)new NullExpressionUsageVisitor(expression, this.getContext()));
        }
        super.visitBinaryExpression(tree);
    }

    private ExpressionTree removeParenthesis(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            return this.removeParenthesis(((ParenthesisedExpressionTree)expressionTree).expression());
        }
        return expressionTree;
    }

    private ExpressionTree getNonNullLiteralOperand(BinaryExpressionTree binaryExpressionTree) {
        if (NullDereferenceInConditionalCheck.isNullOrUndefined((Tree)binaryExpressionTree.leftOperand())) {
            return binaryExpressionTree.rightOperand();
        }
        return binaryExpressionTree.leftOperand();
    }

    private boolean isAndWithEqualToNull(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND}) && this.isNullComparison(tree.leftOperand(), Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO);
    }

    private boolean isOrWithNonEqualToNull(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR}) && this.isNullComparison(tree.leftOperand(), Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO);
    }

    private boolean isNullComparison(ExpressionTree expression, Tree.Kind kind1, Tree.Kind kind2) {
        ExpressionTree tree = this.removeParenthesis(expression);
        if (tree.is(new Tree.Kind[]{kind1, kind2})) {
            BinaryExpressionTree binaryExp = (BinaryExpressionTree)tree;
            return NullDereferenceInConditionalCheck.isNullOrUndefined((Tree)binaryExp.leftOperand()) || NullDereferenceInConditionalCheck.isNullOrUndefined((Tree)binaryExp.rightOperand());
        }
        return false;
    }

    private static boolean isNullOrUndefined(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "undefined".equals(((IdentifierTree)tree).identifierToken().text());
    }

    private class NullExpressionUsageVisitor
    extends BaseTreeVisitor {
        private ExpressionTree nullExpression;
        private AstTreeVisitorContext context;

        public NullExpressionUsageVisitor(ExpressionTree nullExpression, AstTreeVisitorContext context) {
            this.nullExpression = nullExpression;
            this.context = context;
        }

        public void visitMemberExpression(MemberExpressionTree tree) {
            if (SyntacticEquivalence.areEquivalent((Tree)tree.object(), (Tree)this.nullExpression)) {
                this.context.addIssue((JavaScriptCheck)NullDereferenceInConditionalCheck.this, (Tree)this.nullExpression, String.format(NullDereferenceInConditionalCheck.MESSAGE_FORMAT, CheckUtils.asString((Tree)this.nullExpression)));
            }
            super.visitMemberExpression(tree);
        }
    }
}

