/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.SubscriptionBaseVisitor;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="OneStatementPerLine", name="Statements should be on separate lines", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class OneStatementPerLineCheck
extends SubscriptionBaseVisitor {
    private final Map<Integer, Integer> statementsPerLine = Maps.newHashMap();
    private static final String MESSAGE = "At most one statement is allowed per line, but %s statements were found on this line.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE_STATEMENT, (Object)Tree.Kind.EXPRESSION_STATEMENT, (Object)Tree.Kind.IF_STATEMENT, (Object)Tree.Kind.DO_WHILE_STATEMENT, (Object)Tree.Kind.WHILE_STATEMENT, (Object)Tree.Kind.FOR_IN_STATEMENT, (Object)Tree.Kind.FOR_OF_STATEMENT, (Object)Tree.Kind.FOR_STATEMENT, (Object)Tree.Kind.CONTINUE_STATEMENT, (Object)Tree.Kind.BREAK_STATEMENT, (Object)Tree.Kind.RETURN_STATEMENT, (Object)Tree.Kind.WITH_STATEMENT, (Object[])new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.DEBUGGER_STATEMENT, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.SCRIPT});
    }

    public void visitFile(Tree scriptTree) {
        this.statementsPerLine.clear();
    }

    public void visitNode(Tree tree) {
        int line = ((JavaScriptTree)tree).getLine();
        if (tree.is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION}) && this.isFunctionExpressionException((FunctionExpressionTree)tree)) {
            this.statementsPerLine.put(line, this.statementsPerLine.get(line) - 1);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.SCRIPT, Tree.Kind.FUNCTION_EXPRESSION})) {
            return;
        }
        if (!this.statementsPerLine.containsKey(line)) {
            this.statementsPerLine.put(line, 0);
        }
        this.statementsPerLine.put(line, this.statementsPerLine.get(line) + 1);
    }

    private boolean isFunctionExpressionException(FunctionExpressionTree functionExpressionTree) {
        int line = ((JavaScriptTree)functionExpressionTree).getLine();
        List statements = functionExpressionTree.body().statements();
        return statements.size() == 1 && ((JavaScriptTree)statements.get(0)).getLine() == line && this.statementsPerLine.containsKey(line);
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.SCRIPT})) {
            for (Map.Entry<Integer, Integer> statementsAtLine : this.statementsPerLine.entrySet()) {
                if (statementsAtLine.getValue() <= 1) continue;
                this.getContext().addIssue((JavaScriptCheck)this, statementsAtLine.getKey().intValue(), String.format(MESSAGE, statementsAtLine.getValue()));
            }
        }
    }
}

