/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ForInStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="Parentheses", name="Useless parentheses around expressions should be removed to prevent any misunderstanding", priority=Priority.MAJOR, tags={"confusing"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class ParenthesesCheck
extends BaseTreeVisitor {
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.DELETE, Tree.Kind.TYPEOF, Tree.Kind.VOID})) {
            this.checkExpression(tree.expression());
        }
        super.visitUnaryExpression(tree);
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        this.checkExpression(tree.expression());
        super.visitReturnStatement(tree);
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        this.checkExpression(tree.expression());
        super.visitThrowStatement(tree);
    }

    public void visitNewExpression(NewExpressionTree tree) {
        ParenthesisedExpressionTree parenthesisedExpression;
        if (tree.arguments() == null && tree.expression().is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && !((parenthesisedExpression = (ParenthesisedExpressionTree)tree.expression()).expression() instanceof BinaryExpressionTree)) {
            this.checkExpression(tree.expression());
        }
        super.visitNewExpression(tree);
    }

    public void visitForInStatement(ForInStatementTree tree) {
        this.checkExpression(tree.expression());
        super.visitForInStatement(tree);
    }

    private void checkExpression(@Nullable ExpressionTree expression) {
        if (expression != null && expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            String expressingString = CheckUtils.asString((Tree)((ParenthesisedExpressionTree)expression).expression());
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)expression, String.format("The parentheses around \"%s\" are useless.", expressingString));
        }
    }
}

