/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.internal.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.internal.statement.VariableDeclarationTreeImpl;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="RedeclaredVariable", name="Variables should not be redeclared", priority=Priority.MAJOR, tags={"bug"}, status="DEPRECATED")
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class RedeclaredVariableCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<Set<String>> stack;

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.VAR_DECLARATION, Tree.Kind.LET_DECLARATION, Tree.Kind.CONST_DECLARATION});
        this.subscribeTo((AstNodeType[])CheckUtils.functionNodesArray());
    }

    public void visitFile(AstNode astNode) {
        this.stack = new Stack();
        this.stack.add(new HashSet());
    }

    public void visitNode(AstNode astNode) {
        if (CheckUtils.isFunction(astNode)) {
            HashSet<String> currentScope = new HashSet<String>();
            this.stack.add(currentScope);
            this.addParametersToScope(astNode, currentScope);
        } else {
            Set<String> currentScope = this.stack.peek();
            for (IdentifierTree identifier : ((VariableDeclarationTreeImpl)astNode).variableIdentifiers()) {
                String variableName = identifier.name();
                if (currentScope.contains(variableName)) {
                    this.getContext().createLineViolation((CodeCheck)this, "Rename variable \"" + variableName + "\" as this name is already used.", (AstNode)identifier, new Object[0]);
                    continue;
                }
                currentScope.add(variableName);
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        if (CheckUtils.isFunction(astNode)) {
            this.stack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.stack = null;
    }

    private void addParametersToScope(AstNode functionNode, Set<String> currentScope) {
        if (functionNode.is(new AstNodeType[]{Tree.Kind.ARROW_FUNCTION})) {
            RedeclaredVariableCheck.addArrowParametersToScope(((ArrowFunctionTree)functionNode).parameters(), currentScope);
        } else {
            RedeclaredVariableCheck.addFormalParametersToScope((ParameterListTreeImpl)functionNode.getFirstChild(new AstNodeType[]{Tree.Kind.FORMAL_PARAMETER_LIST}), currentScope);
        }
    }

    private static void addArrowParametersToScope(Tree parameters, Set<String> currentScope) {
        if (parameters.is(new Tree.Kind[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
            for (IdentifierTree identifier : ((ParameterListTreeImpl)parameters).parameterIdentifiers()) {
                currentScope.add(identifier.name());
            }
        }
    }

    private static void addFormalParametersToScope(ParameterListTreeImpl formalParameterList, Set<String> currentScope) {
        for (IdentifierTree identifier : formalParameterList.parameterIdentifiers()) {
            currentScope.add(identifier.name());
        }
    }
}

