/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="StrictMode", name="\"strict\" mode should be used with caution", priority=Priority.INFO, tags={"cross-browser", "user-experience"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class StrictModeCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.EXPRESSION_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if ("\"use strict\"".equals(value) || "'use strict'".equals(value)) {
            this.getContext().createLineViolation((CodeCheck)this, "Use of JavaScript strict mode may result in unexpected behaviour in some browsers.", astNode, new Object[0]);
        }
    }
}

