/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Scope;
import org.sonar.javascript.ast.resolve.type.FunctionTree;
import org.sonar.javascript.ast.resolve.type.FunctionType;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.internal.SeparatedList;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S930", name="Function calls should not pass extra arguments", priority=Priority.CRITICAL, tags={"bug", "cwe", "misra"})
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="10min")
@ActivatedByDefault
public class TooManyArgumentsCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "%s expects \"%s\" arguments, but \"%s\" were provided.";

    public void visitCallExpression(CallExpressionTree tree) {
        FunctionTree functionTree = TooManyArgumentsCheck.getFunction(tree);
        if (functionTree != null) {
            int parametersNumber = functionTree.parameters().parameters().size();
            int argumentsNumber = tree.arguments().parameters().size();
            if (!TooManyArgumentsCheck.hasRestParameter(functionTree) && !this.builtInArgumentsUsed(functionTree) && argumentsNumber > parametersNumber) {
                String message = this.getMessage(tree, parametersNumber, argumentsNumber);
                this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree.arguments(), message);
            }
        }
        super.visitCallExpression(tree);
    }

    private String getMessage(CallExpressionTree tree, int parametersNumber, int argumentsNumber) {
        String callee = this.isParenthesisedFunctionExpr(tree.callee()) ? "This function" : "\"" + CheckUtils.asString((Tree)tree.callee()) + "\"";
        return String.format(MESSAGE, callee, parametersNumber, argumentsNumber);
    }

    private boolean isParenthesisedFunctionExpr(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && ((ParenthesisedExpressionTree)tree).expression().is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION});
    }

    private static boolean hasRestParameter(FunctionTree functionTree) {
        SeparatedList parameters = functionTree.parameters().parameters();
        return !parameters.isEmpty() && ((Tree)parameters.get(parameters.size() - 1)).is(new Tree.Kind[]{Tree.Kind.REST_ELEMENT});
    }

    @Nullable
    private static FunctionTree getFunction(CallExpressionTree tree) {
        TypeSet types = tree.callee().types();
        if (types.size() == 1 && ((Type)types.iterator().next()).kind().equals((Object)Type.Kind.FUNCTION)) {
            return ((FunctionType)types.iterator().next()).functionTree();
        }
        return null;
    }

    private boolean builtInArgumentsUsed(FunctionTree tree) {
        Scope scope = this.getContext().getSymbolModel().getScope((Tree)tree);
        if (scope == null) {
            throw new IllegalStateException("No scope found for FunctionTree");
        }
        Symbol argumentsBuiltInVariable = scope.lookupSymbol("arguments");
        if (argumentsBuiltInVariable == null) {
            throw new IllegalStateException("No 'arguments' symbol found for function scope");
        }
        boolean isUsed = !argumentsBuiltInVariable.usages().isEmpty();
        return argumentsBuiltInVariable.builtIn() && isUsed;
    }
}

