/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2817", name="Web SQL databases should not be used", priority=Priority.CRITICAL, tags={"html5", "security", "owasp-a6", "owasp-a9"})
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="2h")
public class WebSQLDatabaseCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Convert this use of a Web SQL database to another technology";
    private static final List<String> OPEN_DATABASE_METHOD_CALLS = ImmutableList.of((Object)"openDatabase", (Object)"window.openDatabase", (Object)"this.openDatabase");

    public void visitCallExpression(CallExpressionTree tree) {
        String callee = CheckUtils.asString((Tree)tree.callee());
        if (OPEN_DATABASE_METHOD_CALLS.contains(callee)) {
            this.getContext().addIssue((JavaScriptCheck)this, (Tree)tree, MESSAGE);
        }
        super.visitCallExpression(tree);
    }
}

