/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.visitors;

import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Settings;
import org.sonar.api.source.Symbolizable;
import org.sonar.javascript.ast.resolve.SymbolModelImpl;
import org.sonar.javascript.ast.visitors.AstTreeVisitorContextImpl;
import org.sonar.javascript.highlighter.SourceFileOffsets;
import org.sonar.plugins.javascript.api.JavaScriptFileScanner;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.sslr.parser.LexerlessGrammar;

public class VisitorsBridge
extends SquidAstVisitor<LexerlessGrammar> {
    private final List<JavaScriptFileScanner> scanners;
    private final ResourcePerspectives resourcePerspectives;
    private final FileSystem fs;
    private static final Logger LOG = LoggerFactory.getLogger(VisitorsBridge.class);
    private final Settings settings;

    public VisitorsBridge(List<JavaScriptFileScanner> visitors, @Nullable ResourcePerspectives resourcePerspectives, FileSystem fs, Settings settings) {
        this.scanners = visitors;
        this.resourcePerspectives = resourcePerspectives;
        this.fs = fs;
        this.settings = settings;
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (astNode != null) {
            ScriptTree scriptTree = (ScriptTree)astNode;
            File file = this.getContext().getFile();
            SymbolModelImpl symbolModel = SymbolModelImpl.create(scriptTree, this.symbolizableFor(file), new SourceFileOffsets(file, this.fs.encoding()), this.settings);
            for (JavaScriptFileScanner scanner : this.scanners) {
                scanner.scanFile(new AstTreeVisitorContextImpl(scriptTree, (SourceFile)this.getContext().peekSourceCode(), file, symbolModel, this.settings));
            }
        }
    }

    @Nullable
    private Symbolizable symbolizableFor(File file) {
        if (this.resourcePerspectives == null) {
            return null;
        }
        InputFile inputFile = this.fs.inputFile(this.fs.predicates().hasAbsolutePath(file.getAbsolutePath()));
        if (inputFile != null) {
            return (Symbolizable)this.resourcePerspectives.as(Symbolizable.class, (InputPath)inputFile);
        }
        LOG.warn("No symbol highlighting for file: " + file.getPath() + ". Unable to find associate SonarQube resource.");
        return null;
    }
}

