/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class BinaryExpressionTreeImpl
extends JavaScriptTree
implements BinaryExpressionTree {
    private final ExpressionTree leftOperand;
    private final SyntaxToken operand;
    private final ExpressionTree rightOperand;
    private final Tree.Kind kind;

    public BinaryExpressionTreeImpl(Tree.Kind kind, ExpressionTree leftOperand, InternalSyntaxToken operand, ExpressionTree rightOperand) {
        super(kind);
        this.leftOperand = (ExpressionTree)Preconditions.checkNotNull((Object)leftOperand);
        this.operand = operand;
        this.rightOperand = (ExpressionTree)Preconditions.checkNotNull((Object)rightOperand);
        this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
        this.addChildren((AstNode)leftOperand, operand, (AstNode)rightOperand);
    }

    @Override
    public ExpressionTree leftOperand() {
        return this.leftOperand;
    }

    @Override
    public SyntaxToken operator() {
        return this.operand;
    }

    @Override
    public ExpressionTree rightOperand() {
        return this.rightOperand;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.leftOperand, this.rightOperand});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    public TypeSet types() {
        return TypeSet.emptyTypeSet();
    }
}

