/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium.common;

import com.google.common.base.Optional;
import com.sun.jersey.api.client.WebResource;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.testobject.appium.common.data.SuiteReport;
import org.testobject.appium.common.data.TestReport;
import org.testobject.appium.common.data.TestResult;
import org.testobject.appium.internal.RestClient;
import org.testobject.appium.junit.internal.Test;

public class AppiumSuiteReportResource {
    private final RestClient client;

    public AppiumSuiteReportResource(RestClient client) {
        this.client = client;
    }

    public SuiteReport startSuiteReport(long suiteId, Optional<String> appId, Set<Test> tests) {
        WebResource webResource = this.client.path("suites").path(Long.toString(suiteId)).path("reports").path("start");
        if (appId.isPresent()) {
            webResource = webResource.queryParam("appId", (String)appId.get());
        }
        return (SuiteReport)webResource.type(MediaType.APPLICATION_JSON_TYPE).post(SuiteReport.class, tests);
    }

    public SuiteReport finishSuiteReport(long suiteId, SuiteReport.Id suiteReportId) {
        return (SuiteReport)this.client.path("suites").path(Long.toString(suiteId)).path("reports").path(Long.toString((Long)suiteReportId.value())).path("finish").type(MediaType.APPLICATION_JSON_TYPE).put(SuiteReport.class);
    }

    public TestReport finishTestReport(long suiteId, SuiteReport.Id suiteReportId, TestReport.Id testReportId, TestResult testResult) {
        return (TestReport)this.client.path("suites").path(Long.toString(suiteId)).path("reports").path(Long.toString((Long)suiteReportId.value())).path("results").path(Integer.toString((Integer)testReportId.value())).path("finish").type(MediaType.APPLICATION_JSON_TYPE).put(TestReport.class, (Object)testResult);
    }
}

