/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium.junit.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.testng.ITestResult;

public class Test {
    private static final Pattern METHOD_AND_CLASS_NAME_PATTERN_STRICT = Pattern.compile("(.+)[\\[\\(](.*)[\\]\\)]");
    private static final Pattern METHOD_AND_CLASS_NAME_PATTERN_LOOSE = Pattern.compile("(.+)");
    private final String className;
    private final String methodName;
    private final String deviceId;

    @JsonCreator
    public Test(@JsonProperty(value="className") String className, @JsonProperty(value="methodName") String methodName, @JsonProperty(value="deviceId") String deviceId) {
        this.className = className;
        this.methodName = methodName;
        this.deviceId = deviceId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Test test = (Test)o;
        if (!this.className.equals(test.className)) {
            return false;
        }
        if (!this.methodName.equals(test.methodName)) {
            return false;
        }
        return this.deviceId.equals(test.deviceId);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.deviceId.hashCode();
        return result;
    }

    public static Test from(Description testDescription) {
        String methodName;
        String className;
        String deviceId = null;
        Matcher matcher = METHOD_AND_CLASS_NAME_PATTERN_STRICT.matcher(testDescription.getMethodName());
        if (matcher.matches()) {
            className = testDescription.getClassName();
            methodName = matcher.group(1);
            deviceId = matcher.group(2);
        } else {
            matcher = METHOD_AND_CLASS_NAME_PATTERN_LOOSE.matcher(testDescription.getMethodName());
            if (matcher.matches()) {
                className = testDescription.getClassName();
                methodName = matcher.group(1);
            } else {
                throw new RuntimeException("unable to match against method name: " + testDescription.getMethodName());
            }
        }
        return new Test(className, methodName, deviceId);
    }

    public static Test from(ITestResult iTestResult) {
        String methodName;
        String className;
        String deviceId = null;
        Matcher matcher = METHOD_AND_CLASS_NAME_PATTERN_STRICT.matcher(iTestResult.getMethod().getMethodName());
        if (matcher.matches()) {
            className = iTestResult.getTestClass().getName();
            methodName = matcher.group(1);
            deviceId = matcher.group(2);
        } else {
            matcher = METHOD_AND_CLASS_NAME_PATTERN_LOOSE.matcher(iTestResult.getMethod().getMethodName());
            if (matcher.matches()) {
                className = iTestResult.getTestClass().getName();
                methodName = matcher.group(1);
            } else {
                throw new RuntimeException("unable to match against method name: " + iTestResult.getMethod().getMethodName());
            }
        }
        return new Test(className, methodName, deviceId);
    }
}

