/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium.junit;

import com.google.common.base.Optional;
import io.appium.java_client.AppiumDriver;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testobject.appium.common.AppiumResource;
import org.testobject.appium.common.AppiumSuiteReportResource;
import org.testobject.appium.common.TestObjectCapabilities;
import org.testobject.appium.common.data.SuiteReport;
import org.testobject.appium.common.data.Test;
import org.testobject.appium.common.data.TestReport;
import org.testobject.appium.common.data.TestResult;
import org.testobject.appium.internal.RestClient;
import org.testobject.appium.junit.internal.Util;

public class TestObjectTestResultWatcher
extends TestWatcher {
    private final String baseUrl;
    private RemoteWebDriver remoteWebDriver;
    private URL driverRemoteAddress;
    private RestClient client;
    private String apiKey;
    private long suiteId;
    private SuiteReport suiteReport;
    private Test test;

    public TestObjectTestResultWatcher() {
        this("https://app.testobject.com:443/api");
    }

    public TestObjectTestResultWatcher(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected void starting(Description description) {
        this.test = Util.from(description);
    }

    protected void succeeded(Description description) {
        this.reportPassed(true, description);
    }

    protected void failed(Throwable e, Description description) {
        this.reportPassed(false, description);
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
        this.reportPassed(false, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finished(Description description) {
        if (this.remoteWebDriver == null) {
            return;
        }
        try {
            this.remoteWebDriver.quit();
        }
        finally {
            this.client.close();
        }
    }

    private void reportPassed(boolean passed, Description description) {
        if (this.remoteWebDriver == null) {
            throw new IllegalStateException("appium driver must be set using setRemoteWebDriver method");
        }
        if (!passed) {
            this.remoteWebDriver.getPageSource();
            this.remoteWebDriver.getScreenshotAs(OutputType.FILE);
        }
        if (!TestObjectCapabilities.toAppiumEndpointURL(this.baseUrl).equals(this.driverRemoteAddress)) {
            return;
        }
        if (this.suiteReport == null) {
            this.createSuiteReportAndTestReport(passed);
        } else {
            this.updateSuiteReport(this.suiteReport, Util.from(description), passed);
        }
    }

    private void updateSuiteReport(SuiteReport suiteReport, Test test, boolean passed) {
        Optional<TestReport.Id> testReportId = suiteReport.getTestReportId(test);
        if (!testReportId.isPresent()) {
            throw new IllegalArgumentException("unknown test " + test);
        }
        new AppiumSuiteReportResource(this.client).finishTestReport(this.suiteId, suiteReport.getId(), (TestReport.Id)testReportId.get(), new TestResult(passed));
    }

    private void createSuiteReportAndTestReport(boolean passed) {
        AppiumResource appiumResource = new AppiumResource(this.client);
        appiumResource.updateTestReportStatus(this.remoteWebDriver.getSessionId(), passed);
    }

    public void setAppiumDriver(AppiumDriver appiumDriver) {
        this.setRemoteWebDriver((RemoteWebDriver)appiumDriver, appiumDriver.getRemoteAddress());
    }

    public void setRemoteWebDriver(RemoteWebDriver remoteWebDriver, URL remoteAddress) {
        if (remoteWebDriver == null) {
            throw new IllegalArgumentException("remoteWebDriver must not be null");
        }
        if (remoteAddress == null) {
            throw new IllegalArgumentException("remoteAddress must not be null");
        }
        this.remoteWebDriver = remoteWebDriver;
        this.driverRemoteAddress = remoteAddress;
        this.client = RestClient.Builder.createClient().withUrl(this.baseUrl).withToken((String)remoteWebDriver.getCapabilities().getCapability("testobject_api_key")).path("/rest/appium/v1/").build();
    }

    public void configureForSuiteExecution(String apiKey, long suiteId, SuiteReport suiteReport) {
        this.apiKey = apiKey;
        this.suiteId = suiteId;
        this.suiteReport = suiteReport;
    }

    public String getTestReportId() {
        if (this.suiteReport == null) {
            return null;
        }
        Optional<TestReport.Id> testReportId = this.suiteReport.getTestReportId(this.test);
        if (!testReportId.isPresent()) {
            throw new IllegalStateException("test report not present");
        }
        return ((TestReport.Id)testReportId.get()).toString();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public URL getTestObjectOrLocalAppiumEndpointURL() throws MalformedURLException {
        if (this.suiteReport == null) {
            return new URL("http://0.0.0.0:4723/wd/hub");
        }
        return TestObjectCapabilities.TESTOBJECT_APPIUM_ENDPOINT;
    }
}

