/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium.testng;

import io.appium.java_client.AppiumDriver;
import java.net.URL;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testobject.appium.common.AppiumResource;
import org.testobject.appium.common.TestObjectCapabilities;
import org.testobject.appium.internal.RestClient;
import org.testobject.appium.testng.AppiumDriverProvider;
import org.testobject.appium.testng.RemoteWebDriverProvider;

public class TestObjectTestNGTestResultWatcher
extends TestListenerAdapter {
    private RemoteWebDriver remoteWebDriver;
    private URL driverRemoteAddress;
    private RestClient client;

    public void onTestStart(ITestResult testResult) {
        AppiumDriver driver;
        super.onTestStart(testResult);
        if (testResult.getInstance() instanceof AppiumDriverProvider) {
            driver = ((AppiumDriverProvider)testResult.getInstance()).getAppiumDriver();
            this.setAppiumDriver(driver);
        }
        if (testResult.getInstance() instanceof RemoteWebDriverProvider) {
            driver = ((RemoteWebDriverProvider)testResult.getInstance()).getRemoteWebDriver();
            this.driverRemoteAddress = ((RemoteWebDriverProvider)testResult.getInstance()).getRemoteAddress();
            this.setRemoteWebDriver((RemoteWebDriver)driver, this.driverRemoteAddress);
        }
    }

    public void onTestSuccess(ITestResult tr) {
        super.onTestSuccess(tr);
        this.reportPassed(true);
    }

    public void onTestFailure(ITestResult tr) {
        super.onTestFailure(tr);
        this.reportPassed(false);
    }

    public void onTestSkipped(ITestResult tr) {
        super.onTestSkipped(tr);
        this.reportPassed(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinish(ITestContext testContext) {
        super.onFinish(testContext);
        if (this.remoteWebDriver == null) {
            return;
        }
        try {
            this.remoteWebDriver.quit();
        }
        finally {
            this.client.close();
        }
    }

    private void reportPassed(boolean passed) {
        if (this.remoteWebDriver == null) {
            throw new IllegalStateException("appium driver must be set using setRemoteWebDriver method");
        }
        if (!passed) {
            this.remoteWebDriver.getPageSource();
            this.remoteWebDriver.getScreenshotAs(OutputType.FILE);
        }
        if (!TestObjectCapabilities.toAppiumEndpointURL("https://app.testobject.com:443/api").equals(this.driverRemoteAddress)) {
            return;
        }
        this.createSuiteReportAndTestReport(passed);
    }

    private void createSuiteReportAndTestReport(boolean passed) {
        AppiumResource appiumResource = new AppiumResource(this.client);
        appiumResource.updateTestReportStatus(this.remoteWebDriver.getSessionId(), passed);
    }

    public void setAppiumDriver(AppiumDriver appiumDriver) {
        this.setRemoteWebDriver((RemoteWebDriver)appiumDriver, appiumDriver.getRemoteAddress());
    }

    public void setRemoteWebDriver(RemoteWebDriver remoteWebDriver, URL remoteAddress) {
        if (remoteWebDriver == null) {
            throw new IllegalArgumentException("remoteWebDriver must not be null");
        }
        if (remoteAddress == null) {
            throw new IllegalArgumentException("remoteAddress must not be null");
        }
        this.remoteWebDriver = remoteWebDriver;
        this.driverRemoteAddress = remoteAddress;
        this.client = RestClient.Builder.createClient().withUrl("https://app.testobject.com:443/api").withToken((String)remoteWebDriver.getCapabilities().getCapability("testobject_api_key")).path("/rest/appium/v1/").build();
    }
}

