/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium.common.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.Set;
import org.testobject.appium.common.data.Test;
import org.testobject.appium.common.data.TestReport;

public class SuiteReport {
    private final Id id;
    private final Set<TestReport> testReports;

    @JsonCreator
    public SuiteReport(@JsonProperty(value="id") Id id, @JsonProperty(value="testReports") Set<TestReport> testReports) {
        this.id = id;
        this.testReports = testReports;
    }

    public Id getId() {
        return this.id;
    }

    public Optional<TestReport.Id> getTestReportId(Test test) {
        for (TestReport testReport : this.testReports) {
            if (!testReport.getTest().equals(test)) continue;
            return Optional.of((Object)testReport.getId());
        }
        return Optional.absent();
    }

    public Optional<String> getTestDeviceId(Test test) {
        for (TestReport testReport : this.testReports) {
            if (!testReport.getTest().equals(test)) continue;
            return Optional.of((Object)testReport.getTest().getDeviceId());
        }
        return Optional.absent();
    }

    public static class Id
    extends org.testobject.appium.common.data.Id<Long> {
        public Id(Long value) {
            super(value);
        }
    }
}

