/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium.internal;

import com.google.common.base.Optional;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.ApacheHttpClientConfig;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import java.io.Closeable;
import java.net.URI;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class RestClient
implements Closeable {
    public static final String REST_APPIUM_PATH = "/rest/appium/v1/";
    public static final String REST_DEVICES_PATH = "/rest/devices/v1/";
    private final Client client;
    private final WebResource baseResource;

    RestClient(Client client, WebResource baseResource) {
        this.client = client;
        this.baseResource = baseResource;
    }

    public WebResource path(String path) {
        return this.baseResource.path(path);
    }

    @Override
    public void close() {
        this.client.destroy();
    }

    public static final class Builder {
        private Client client;
        private String baseUrl;
        private String path = "";
        private String token = "";

        public static Builder createClient() {
            return new Builder();
        }

        public Builder withUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public RestClient build() {
            DefaultApacheHttpClientConfig config = new DefaultApacheHttpClientConfig();
            config.getProperties().put("com.sun.jersey.impl.client.httpclient.handleCookies", true);
            Builder.addProxyConfiguration((ApacheHttpClientConfig)config, this.baseUrl);
            this.client = ApacheHttpClient.create((ClientConfig)config);
            this.client.addFilter((ClientFilter)new LoggingFilter(System.out));
            this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.token, ""));
            WebResource webResource = this.client.resource(this.baseUrl + this.path);
            return new RestClient(this.client, webResource);
        }

        private static void addProxyConfiguration(ApacheHttpClientConfig config, String baseUrl) {
            String protocol = URI.create(baseUrl).getScheme().toLowerCase();
            Optional proxyHost = Optional.fromNullable((Object)System.getProperty(protocol + ".proxyHost"));
            if (!proxyHost.isPresent()) {
                return;
            }
            String host = (String)proxyHost.get();
            String port = (String)Optional.fromNullable((Object)System.getProperty(protocol + ".proxyPort")).or((Object)"8080");
            String proxyProtocol = (String)Optional.fromNullable((Object)System.getProperty(protocol + ".proxyProtocol")).or((Object)"http");
            String url = proxyProtocol + "://" + host + ":" + port;
            config.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", url);
            Optional username = Optional.fromNullable((Object)System.getProperty(protocol + ".proxyUser"));
            Optional password = Optional.fromNullable((Object)System.getProperty(protocol + ".proxyPassword"));
            if (username.isPresent() && password.isPresent()) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials((String)username.get(), (String)password.get());
                config.getState().getHttpState().setProxyCredentials(AuthScope.ANY, (Credentials)credentials);
            }
        }
    }
}

