/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium.junit;

import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.testobject.appium.common.AppiumSuiteReportResource;
import org.testobject.appium.common.AppiumSuiteResource;
import org.testobject.appium.common.Env;
import org.testobject.appium.common.TestObject;
import org.testobject.appium.common.data.SuiteReport;
import org.testobject.appium.common.data.Test;
import org.testobject.appium.internal.RestClient;
import org.testobject.appium.junit.TestObjectTestResultWatcher;
import org.testobject.appium.junit.internal.Util;

public class TestObjectAppiumSuite
extends Suite {
    private static final List<Runner> NO_RUNNERS = Collections.emptyList();
    private static final int timeoutDefault = 60;
    private static final TimeUnit timeunitDefault = TimeUnit.MINUTES;
    private final RestClient client;
    private final List<Runner> perDeviceRunners;
    private String testObjectApiKey;
    private long testObjectSuiteId;
    private Optional<String> testObjectAppId;
    private String[] testObjectDeviceIds;
    private boolean runLocally;
    private SuiteReport suiteReport;

    public TestObjectAppiumSuite(Class<?> clazz) throws InitializationError {
        super(clazz, NO_RUNNERS);
        TestObject config = TestObjectAppiumSuite.getConfig(clazz);
        Optional<String> runLocallyFromEnvironment = Env.isTestLocally();
        boolean bl = this.runLocally = runLocallyFromEnvironment.isPresent() ? Boolean.valueOf((String)runLocallyFromEnvironment.get()).booleanValue() : config.testLocally();
        if (this.runLocally) {
            this.client = null;
            Set<String> deviceIds = this.getLocalDeviceId();
            this.perDeviceRunners = this.toRunners(clazz, deviceIds);
            this.setScheduler(new ThreadPoolScheduler(deviceIds.size(), 60, timeunitDefault));
        } else {
            Optional<String> endpointFromEnvironment = Env.getApiEndpoint();
            String testObjectApiEndpoint = endpointFromEnvironment.isPresent() ? (String)endpointFromEnvironment.get() : config.testObjectApiEndpoint();
            Optional<String> apiKeyFromEnvironment = Env.getApiKey();
            this.testObjectApiKey = apiKeyFromEnvironment.isPresent() ? (String)apiKeyFromEnvironment.get() : config.testObjectApiKey();
            Optional<String> suiteIdFromEnvironment = Env.getSuiteId();
            this.testObjectSuiteId = suiteIdFromEnvironment.isPresent() ? Long.parseLong((String)suiteIdFromEnvironment.get()) : config.testObjectSuiteId();
            Optional appIdFromEnvironment = Env.getAppId();
            Optional appIdFromAnnotation = config.testObjectAppId() != 0L ? Optional.of((Object)Long.toString(config.testObjectAppId())) : Optional.absent();
            this.testObjectAppId = appIdFromEnvironment.isPresent() ? appIdFromEnvironment : appIdFromAnnotation;
            Optional<String> deviceIdsFromEnvironment = Env.getDevicesIds();
            this.testObjectDeviceIds = deviceIdsFromEnvironment.isPresent() ? ((String)deviceIdsFromEnvironment.get()).split(", ") : config.testObjectDeviceIds();
            Optional<String> timeoutFromEnvironment = Env.getTimeout();
            int testObjectTimeout = timeoutFromEnvironment.isPresent() ? Integer.parseInt((String)timeoutFromEnvironment.get()) : config.timeout();
            this.client = RestClient.Builder.createClient().withUrl(testObjectApiEndpoint).withToken(this.testObjectApiKey).path("/rest/appium/v1/").build();
            Set<String> deviceIds = this.testObjectDeviceIds.length == 0 ? this.getRemoteDeviceIds() : new HashSet<String>(Arrays.asList(this.testObjectDeviceIds));
            this.perDeviceRunners = this.toRunners(clazz, deviceIds);
            this.setScheduler(new ThreadPoolScheduler(deviceIds.size(), testObjectTimeout, config.timeoutUnit()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        Set<Test> tests = TestObjectAppiumSuite.getTests(this.getDescription());
        if (this.runLocally) {
            super.run(notifier);
        } else {
            AppiumSuiteReportResource suiteReportResource = new AppiumSuiteReportResource(this.client);
            try {
                this.suiteReport = suiteReportResource.startSuiteReport(this.testObjectSuiteId, this.testObjectAppId, tests);
                try {
                    super.run(notifier);
                }
                finally {
                    suiteReportResource.finishSuiteReport(this.testObjectSuiteId, this.suiteReport.getId());
                }
            }
            finally {
                this.client.close();
            }
        }
    }

    protected List<Runner> getChildren() {
        return this.perDeviceRunners;
    }

    private static TestObject getConfig(Class<?> clazz) {
        TestObject testobject = clazz.getAnnotation(TestObject.class);
        if (testobject == null) {
            throw new IllegalStateException("class " + clazz + " must be annotated with " + TestObject.class.getName());
        }
        return testobject;
    }

    private Set<String> getRemoteDeviceIds() {
        if (this.testObjectDeviceIds != null && this.testObjectDeviceIds.length > 0) {
            return new HashSet<String>(Arrays.asList(this.testObjectDeviceIds));
        }
        AppiumSuiteResource suiteReportResource = new AppiumSuiteResource(this.client);
        Set<String> deviceIds = suiteReportResource.readSuiteDeviceIds(this.testObjectSuiteId);
        return deviceIds;
    }

    private Set<String> getLocalDeviceId() {
        return new HashSet<String>(Collections.singletonList("Local_device"));
    }

    private List<Runner> toRunners(Class<?> clazz, Set<String> deviceIds) throws InitializationError {
        ArrayList<Runner> runners = new ArrayList<Runner>(deviceIds.size());
        for (String deviceId : deviceIds) {
            runners.add((Runner)new PerDeviceRunner(clazz, deviceId));
        }
        return runners;
    }

    private static Set<Test> getTests(Description description) {
        HashSet<Test> tests = new HashSet<Test>();
        for (Description childDescription : description.getChildren()) {
            for (Description testDescription : childDescription.getChildren()) {
                tests.add(Util.from(testDescription));
            }
        }
        return tests;
    }

    protected static class ThreadPoolScheduler
    implements RunnerScheduler {
        private final int timeout;
        private final TimeUnit timeoutUnit;
        private final ExecutorService executor;

        public ThreadPoolScheduler(int numberOfThreads, int timeout, TimeUnit timeoutUnit) {
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
            this.executor = Executors.newFixedThreadPool(numberOfThreads);
        }

        public void schedule(Runnable childStatement) {
            this.executor.submit(childStatement);
        }

        public void finished() {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(this.timeout, this.timeoutUnit);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    private class PerDeviceRunner
    extends BlockJUnit4ClassRunner {
        private final String deviceId;

        public PerDeviceRunner(Class<?> clazz, String deviceId) throws InitializationError {
            super(clazz);
            this.deviceId = deviceId;
        }

        protected Description describeChild(FrameworkMethod method) {
            return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)(this.testName(method) + "[" + this.deviceId + "]"), (Annotation[])method.getAnnotations());
        }

        protected List<TestRule> getTestRules(Object target) {
            List testRules = super.getTestRules(target);
            for (TestRule testRule : testRules) {
                if (!(testRule instanceof TestObjectTestResultWatcher)) continue;
                TestObjectTestResultWatcher resultWatcher = (TestObjectTestResultWatcher)testRule;
                resultWatcher.configureForSuiteExecution(TestObjectAppiumSuite.this.testObjectApiKey, TestObjectAppiumSuite.this.testObjectSuiteId, TestObjectAppiumSuite.this.suiteReport);
            }
            return testRules;
        }

        protected String getName() {
            return super.getName() + "[" + this.deviceId + "]";
        }
    }
}

