/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium;

import javax.ws.rs.core.Response;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testobject.appium.TestObjectListenerProvider;
import org.testobject.rest.api.RestClient;
import org.testobject.rest.api.resource.v2.AppiumSessionResource;

public abstract class ResultReporter {
    protected RestClient client;
    protected TestObjectListenerProvider provider;

    protected ResultReporter() {
    }

    public ResultReporter(TestObjectListenerProvider provider) {
        this.provider = provider;
        this.initClient();
    }

    protected void initClient() {
        String apiEndpoint = this.provider.getAPIEndpoint().toString();
        RemoteWebDriver remoteWebDriver = this.provider.getRemoteWebDriver();
        this.client = RestClient.Builder.createClient().withUrl(apiEndpoint).withToken((String)remoteWebDriver.getCapabilities().getCapability("testobject_api_key")).path("/rest/").build();
    }

    public void close() {
        RemoteWebDriver remoteWebDriver = this.provider.getRemoteWebDriver();
        if (remoteWebDriver == null) {
            return;
        }
        remoteWebDriver.quit();
        this.client.close();
    }

    public void createSuiteReportAndTestReport(boolean passed) {
        AppiumSessionResource appiumSessionResource = new AppiumSessionResource(this.client);
        Response response = appiumSessionResource.updateTestReportStatus(this.provider.getRemoteWebDriver().getSessionId().toString(), passed);
        if (response.getStatus() != 204) {
            System.out.println("Test result might not be updated on Sauce Labs RDC (TestObject). Status: " + response.getStatus());
        }
    }

    public void processResult(boolean passed) {
        RemoteWebDriver remoteWebDriver = this.provider.getRemoteWebDriver();
        if (remoteWebDriver == null) {
            throw new IllegalStateException("appium driver must be set using setDriver method");
        }
        if (!passed) {
            this.requestScreenshotAndPageSource();
        }
        if (this.provider.isLocalTest()) {
            return;
        }
    }

    public void requestScreenshotAndPageSource() {
        RemoteWebDriver remoteWebDriver = this.provider.getRemoteWebDriver();
        remoteWebDriver.getPageSource();
        remoteWebDriver.getScreenshotAs(OutputType.FILE);
    }
}

