/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium;

import org.testobject.appium.ResultReporter;
import org.testobject.appium.TestObjectListenerProvider;
import org.testobject.rest.api.appium.common.data.SuiteReport;
import org.testobject.rest.api.appium.common.data.Test;
import org.testobject.rest.api.appium.common.data.TestReport;
import org.testobject.rest.api.appium.common.data.TestResult;
import org.testobject.rest.api.resource.v2.AppiumReportResource;

public class SuiteReporter
extends ResultReporter {
    private SuiteReport suiteReport;
    private long suiteId;

    public void setSuiteReport(SuiteReport suiteReport) {
        this.suiteReport = suiteReport;
    }

    public void setSuiteId(long suiteId) {
        this.suiteId = suiteId;
    }

    public void processAndReportResult(boolean passed, Test test) {
        this.processResult(passed);
        this.reportResult(passed, test);
    }

    public void reportResult(boolean passed, Test test) {
        if (this.suiteReport == null) {
            this.createSuiteReportAndTestReport(passed);
        } else {
            this.updateSuiteReport(this.suiteReport, test, passed);
        }
    }

    private void updateSuiteReport(SuiteReport suiteReport, Test test, boolean passed) {
        TestReport.Id testReportId = (TestReport.Id)suiteReport.getTestReportId(test).orElseThrow(() -> new IllegalArgumentException("unknown test " + test));
        new AppiumReportResource(this.client).finishAppiumTestReport(this.suiteId, suiteReport.getId(), testReportId, new TestResult(passed));
    }

    public SuiteReport suiteReport() {
        return this.suiteReport;
    }

    public void setProvider(TestObjectListenerProvider provider) {
        this.provider = provider;
        super.initClient();
    }
}

