/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium.junit;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.testobject.appium.junit.TestObjectAppiumSuiteWatcher;
import org.testobject.appium.junit.TestParser;
import org.testobject.rest.api.RestClient;
import org.testobject.rest.api.appium.common.Env;
import org.testobject.rest.api.appium.common.TestObject;
import org.testobject.rest.api.appium.common.TestObjectCapabilities;
import org.testobject.rest.api.appium.common.data.DataCenterSuite;
import org.testobject.rest.api.appium.common.data.SuiteReport;
import org.testobject.rest.api.appium.common.data.Test;
import org.testobject.rest.api.resource.v2.AppiumReportResource;
import org.testobject.rest.api.resource.v2.AppiumSuiteResource;

public class TestObjectAppiumSuite
extends Suite {
    private static final List<Runner> NO_RUNNERS = Collections.emptyList();
    private static final int timeoutDefault = 60;
    private static final TimeUnit timeunitDefault = TimeUnit.MINUTES;
    private final RestClient client;
    private final List<Runner> perDeviceRunners;
    private String testObjectApiKey;
    private long testObjectSuiteId;
    private Optional<String> testObjectAppId;
    private boolean runLocally;
    private SuiteReport suiteReport;

    public TestObjectAppiumSuite(Class<?> clazz) throws InitializationError {
        super(clazz, NO_RUNNERS);
        TestObject config = TestObjectAppiumSuite.getConfig(clazz);
        Optional runLocallyFromEnvironment = Env.isTestLocally();
        boolean bl = this.runLocally = runLocallyFromEnvironment.isPresent() ? Boolean.valueOf((String)runLocallyFromEnvironment.get()).booleanValue() : config.testLocally();
        if (this.runLocally) {
            this.client = null;
            this.perDeviceRunners = new LinkedList<Runner>();
            this.perDeviceRunners.add((Runner)new PerDeviceRunner(clazz, null, null, null));
            this.setScheduler(new ThreadPoolScheduler(1, 60, timeunitDefault));
        } else {
            Optional endpointFromEnvironment = Env.getApiEndpoint();
            String endpointFromConfig = config.testObjectApiEndpoint().isEmpty() ? TestObjectCapabilities.TESTOBJECT_API_ENDPOINT.toString() : config.testObjectApiEndpoint();
            String testObjectApiEndpoint = endpointFromEnvironment.orElse(endpointFromConfig);
            Optional apiKeyFromEnvironment = Env.getApiKey();
            this.testObjectApiKey = apiKeyFromEnvironment.orElseGet(() -> ((TestObject)config).testObjectApiKey());
            Optional suiteIdFromEnvironment = Env.getSuiteId();
            this.testObjectSuiteId = suiteIdFromEnvironment.map(Long::parseLong).orElseGet(() -> ((TestObject)config).testObjectSuiteId());
            Optional appIdFromEnvironment = Env.getAppId();
            Optional appIdFromAnnotation = config.testObjectAppId() != 0L ? Optional.of(Long.toString(config.testObjectAppId())) : Optional.empty();
            this.testObjectAppId = appIdFromEnvironment.isPresent() ? appIdFromEnvironment : appIdFromAnnotation;
            Optional timeoutFromEnvironment = Env.getTimeout();
            int testObjectTimeout = timeoutFromEnvironment.map(Integer::parseInt).orElseGet(() -> ((TestObject)config).timeout());
            this.client = RestClient.Builder.createClient().withUrl(testObjectApiEndpoint).withToken(this.testObjectApiKey).path("/rest/").build();
            Set<DataCenterSuite> dataCenterSuites = this.getDataCenterSuites();
            this.perDeviceRunners = this.toRunners(clazz, dataCenterSuites);
            this.setScheduler(new ThreadPoolScheduler(this.perDeviceRunners.size(), testObjectTimeout, config.timeoutUnit()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        Set<Test> tests = TestObjectAppiumSuite.getTests(this.getDescription());
        if (this.runLocally) {
            super.run(notifier);
        } else {
            AppiumReportResource appiumReportResource = new AppiumReportResource(this.client);
            try {
                this.suiteReport = appiumReportResource.startAppiumSuite(this.testObjectSuiteId, this.testObjectAppId, tests);
                try {
                    super.run(notifier);
                }
                finally {
                    appiumReportResource.finishAppiumSuite(this.testObjectSuiteId, this.suiteReport.getId());
                }
            }
            finally {
                this.client.close();
            }
        }
    }

    protected List<Runner> getChildren() {
        return this.perDeviceRunners;
    }

    private static TestObject getConfig(Class<?> clazz) {
        TestObject testobject = clazz.getAnnotation(TestObject.class);
        if (testobject == null) {
            throw new IllegalStateException("class " + clazz + " must be annotated with " + TestObject.class.getName());
        }
        return testobject;
    }

    private Set<DataCenterSuite> getDataCenterSuites() {
        AppiumSuiteResource suiteReportResource = new AppiumSuiteResource(this.client);
        return suiteReportResource.readDeviceDescriptorIds(this.testObjectSuiteId);
    }

    private List<Runner> toRunners(Class<?> clazz, Collection<DataCenterSuite> dataCenterSuites) throws InitializationError {
        LinkedList<Runner> runners = new LinkedList<Runner>();
        for (DataCenterSuite dataCenterSuite : dataCenterSuites) {
            URL appiumURL = dataCenterSuite.getDataCenterURL();
            String dataCenterId = dataCenterSuite.dataCenterId;
            for (String deviceId : dataCenterSuite.getDeviceDescriptorIds()) {
                runners.add((Runner)new PerDeviceRunner(clazz, deviceId, dataCenterId, appiumURL));
            }
        }
        if (runners.size() < 1) {
            throw new RuntimeException("No devices were specified for this suite");
        }
        return runners;
    }

    private static Set<Test> getTests(Description description) {
        HashSet<Test> tests = new HashSet<Test>();
        for (Description childDescription : description.getChildren()) {
            for (Description testDescription : childDescription.getChildren()) {
                tests.add(TestParser.from(testDescription));
            }
        }
        return tests;
    }

    protected static class ThreadPoolScheduler
    implements RunnerScheduler {
        private final int timeout;
        private final TimeUnit timeoutUnit;
        private final ExecutorService executor;

        public ThreadPoolScheduler(int numberOfThreads, int timeout, TimeUnit timeoutUnit) {
            if (numberOfThreads < 1) {
                throw new RuntimeException("Cannot make a thread pool with " + numberOfThreads + " threads");
            }
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
            this.executor = Executors.newFixedThreadPool(numberOfThreads);
        }

        public void schedule(Runnable childStatement) {
            this.executor.submit(childStatement);
        }

        public void finished() {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(this.timeout, this.timeoutUnit);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    private class PerDeviceRunner
    extends BlockJUnit4ClassRunner {
        private final String deviceId;
        private final String dataCenterId;
        private final URL appiumURL;

        public PerDeviceRunner(Class<?> clazz, String deviceId, String dataCenterId, URL appiumURL) throws InitializationError {
            super(clazz);
            this.deviceId = deviceId;
            this.dataCenterId = dataCenterId;
            this.appiumURL = appiumURL;
        }

        protected Description describeChild(FrameworkMethod method) {
            String descriptionName = this.testName(method) + " " + this.deviceId + " " + this.dataCenterId;
            return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)descriptionName, (Annotation[])method.getAnnotations());
        }

        protected List<TestRule> getTestRules(Object target) {
            List testRules = super.getTestRules(target);
            for (TestRule testRule : testRules) {
                if (!(testRule instanceof TestObjectAppiumSuiteWatcher)) continue;
                TestObjectAppiumSuiteWatcher resultWatcher = (TestObjectAppiumSuiteWatcher)testRule;
                resultWatcher.configure(TestObjectAppiumSuite.this.testObjectApiKey, TestObjectAppiumSuite.this.testObjectSuiteId, TestObjectAppiumSuite.this.suiteReport, TestObjectAppiumSuite.this.runLocally, this.appiumURL);
            }
            return testRules;
        }

        protected String getName() {
            return super.getName() + "[" + this.deviceId + "]";
        }
    }
}

