/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium.junit;

import java.net.MalformedURLException;
import java.net.URL;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testobject.appium.SuiteReporter;
import org.testobject.appium.TestObjectListenerProvider;
import org.testobject.appium.junit.TestParser;
import org.testobject.rest.api.appium.common.TestObjectCapabilities;
import org.testobject.rest.api.appium.common.data.SuiteReport;
import org.testobject.rest.api.appium.common.data.Test;
import org.testobject.rest.api.appium.common.data.TestReport;

public class TestObjectAppiumSuiteWatcher
extends TestWatcher {
    private String apiKey;
    private Test test;
    private boolean isLocalTest;
    private URL appiumURL;
    private SuiteReporter reporter;
    private TestObjectListenerProvider provider = TestObjectListenerProvider.newInstance();

    protected void starting(Description description) {
        this.test = TestParser.from(description);
    }

    protected void succeeded(Description description) {
        this.reporter.processAndReportResult(true, TestParser.from(description));
    }

    protected void failed(Throwable e, Description description) {
        this.reporter.processAndReportResult(false, TestParser.from(description));
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
        this.reporter.processAndReportResult(false, TestParser.from(description));
    }

    protected void skipped(org.junit.AssumptionViolatedException e, Description description) {
        this.reporter.processAndReportResult(false, TestParser.from(description));
    }

    protected void finished(Description description) {
        this.reporter.close();
    }

    public void setRemoteWebDriver(RemoteWebDriver driver) {
        this.setRemoteWebDriver(driver, TestObjectCapabilities.TESTOBJECT_API_ENDPOINT);
    }

    public void setRemoteWebDriver(RemoteWebDriver driver, URL apiEndpoint) {
        this.provider.setDriver(driver, apiEndpoint);
        this.reporter.setProvider(this.provider);
    }

    public void configure(String apiKey, long suiteId, SuiteReport suiteReport, boolean isLocalTest, URL appiumURL) {
        this.reporter = new SuiteReporter();
        this.setApiKey(apiKey);
        this.setSuiteId(suiteId);
        this.setSuiteReport(suiteReport);
        this.setIsLocalTest(isLocalTest);
        this.setAppiumURL(appiumURL);
    }

    public void setIsLocalTest(boolean isLocalTest) {
        this.isLocalTest = isLocalTest;
        this.provider.setLocalTest(isLocalTest);
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setSuiteId(long suiteId) {
        this.reporter.setSuiteId(suiteId);
    }

    public void setSuiteReport(SuiteReport suiteReport) {
        this.reporter.setSuiteReport(suiteReport);
    }

    public void setAppiumURL(URL appiumURL) {
        this.appiumURL = appiumURL;
    }

    public String getTestReportId() {
        return ((TestReport.Id)this.reporter.suiteReport().getTestReportId(this.test).orElseThrow(() -> new IllegalStateException("test report not present"))).toString();
    }

    public String getTestDeviceId() {
        return (String)this.reporter.suiteReport().getTestDeviceId(this.test).orElseThrow(() -> new IllegalStateException("test device not present"));
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public URL getTestObjectOrLocalAppiumEndpointURL() throws MalformedURLException {
        if (this.isLocalTest) {
            return new URL("http://0.0.0.0:4723/wd/hub");
        }
        return this.appiumURL;
    }
}

