/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium.junit;

import java.net.URL;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testobject.appium.IntermediateReporter;
import org.testobject.appium.TestObjectListenerProvider;

public class TestObjectTestResultWatcher
extends TestWatcher {
    private IntermediateReporter reporter;
    private TestObjectListenerProvider provider = TestObjectListenerProvider.newInstance();

    protected void succeeded(Description description) {
        this.reporter.processAndReportResult(true);
    }

    protected void failed(Throwable e, Description description) {
        this.reporter.processAndReportResult(false);
    }

    protected void skipped(org.junit.AssumptionViolatedException e, Description description) {
        this.reporter.processAndReportResult(false);
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
        this.reporter.processAndReportResult(false);
    }

    protected void finished(Description description) {
        this.reporter.close();
    }

    public void setRemoteWebDriver(RemoteWebDriver driver) {
        this.provider.setDriver(driver);
        this.reporter = new IntermediateReporter(this.provider);
    }

    public void setRemoteWebDriver(RemoteWebDriver driver, URL apiEndpoint) {
        this.provider.setDriver(driver, apiEndpoint);
        this.reporter = new IntermediateReporter(this.provider);
    }

    public void setIsLocalTest(boolean isLocalTest) {
        this.provider.setLocalTest(isLocalTest);
    }
}

