/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium.testng;

import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testobject.appium.IntermediateReporter;
import org.testobject.appium.TestObjectListenerProvider;
import org.testobject.appium.testng.TestObjectWatcherProvider;

public class TestObjectTestNGTestResultWatcher
extends TestListenerAdapter {
    private IntermediateReporter reporter;

    public void onTestStart(ITestResult testResult) {
        super.onTestStart(testResult);
        Object instance = testResult.getInstance();
        if (!(instance instanceof TestObjectWatcherProvider)) {
            throw new IllegalStateException("Test must implement TestObjectWatcherProvider");
        }
        TestObjectWatcherProvider watcherProvider = (TestObjectWatcherProvider)instance;
        TestObjectListenerProvider provider = watcherProvider.getProvider();
        this.reporter = new IntermediateReporter(provider);
    }

    public void onTestSuccess(ITestResult tr) {
        super.onTestSuccess(tr);
        this.reporter.processAndReportResult(true);
    }

    public void onTestFailure(ITestResult tr) {
        super.onTestFailure(tr);
        this.reporter.processAndReportResult(false);
    }

    public void onTestSkipped(ITestResult tr) {
        super.onTestSkipped(tr);
        this.reporter.processAndReportResult(false);
    }

    public void onFinish(ITestContext testContext) {
        super.onFinish(testContext);
        this.reporter.close();
    }
}

