/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.config.table;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.database.config.table.ForeignReference;
import org.tinygroup.database.config.table.Index;
import org.tinygroup.database.config.table.TableField;
import org.tinygroup.metadata.config.BaseObject;
import org.tinygroup.metadata.config.ExtendProperties;

@XStreamAlias(value="table")
public class Table
extends BaseObject {
    @XStreamAsAttribute
    private String schema;
    @XStreamImplicit
    private List<TableField> fieldList;
    @XStreamImplicit
    private List<Index> indexList;
    @XStreamAsAttribute
    @XStreamAlias(value="package-name")
    private String packageName;
    @XStreamImplicit
    private List<ForeignReference> foreignReferences;
    @XStreamAlias(value="extend-properties")
    private ExtendProperties extendProperties;
    @XStreamAsAttribute
    @XStreamAlias(value="table-space")
    private String tableSpace;

    public String getNameWithOutSchema() {
        return super.getName();
    }

    public String getName() {
        if (this.getSchema() == null || "".equals(this.getSchema())) {
            return super.getName();
        }
        return String.format("%s.%s", this.getSchema(), super.getName());
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public List<TableField> getFieldList() {
        if (this.fieldList == null) {
            this.fieldList = new ArrayList<TableField>();
        }
        return this.fieldList;
    }

    public void setFieldList(List<TableField> fieldList) {
        this.fieldList = fieldList;
    }

    public List<Index> getIndexList() {
        if (this.indexList == null) {
            this.indexList = new ArrayList<Index>();
        }
        return this.indexList;
    }

    public void setIndexList(List<Index> indexList) {
        this.indexList = indexList;
    }

    public List<ForeignReference> getForeignReferences() {
        if (this.foreignReferences == null) {
            this.foreignReferences = new ArrayList<ForeignReference>();
        }
        return this.foreignReferences;
    }

    public void setForeignReferences(List<ForeignReference> foreignReferences) {
        this.foreignReferences = foreignReferences;
    }

    public ExtendProperties getExtendProperties() {
        return this.extendProperties;
    }

    public void setExtendProperties(ExtendProperties extendProperties) {
        this.extendProperties = extendProperties;
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace;
    }
}

