/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.customesql.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.database.config.SqlBody;
import org.tinygroup.database.config.customsql.CustomSql;
import org.tinygroup.database.config.customsql.CustomSqls;
import org.tinygroup.database.customesql.CustomSqlProcessor;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.metadata.checkupdate.MetaDataFileInfo;
import org.tinygroup.metadata.checkupdate.MetaDataFileManager;

public class CustomSqlProcessorImpl
implements CustomSqlProcessor {
    private static CustomSqlProcessor defaultCustomSqlProcessor = new CustomSqlProcessorImpl();
    private MetaDataFileManager metaDataFileManager = MetaDataFileManager.getInstance();
    private Map<String, Long> customSqlModifiedTimeMap = new HashMap<String, Long>();
    private CustomSqls customSqls;

    public static CustomSqlProcessor getCustomSqlProcessor() {
        return defaultCustomSqlProcessor;
    }

    public CustomSqls getCustomSqls() {
        return this.customSqls;
    }

    public void setCustomSqls(CustomSqls customSqls) {
        this.customSqls = customSqls;
    }

    @Override
    public List<String> getCustomSqls(String type, String language) {
        HashMap<String, Map<String, List<String>>> sqlsMap = new HashMap<String, Map<String, List<String>>>();
        this.createSqlsByCustomSql(sqlsMap);
        List customSqls = null;
        if (sqlsMap.containsKey(language)) {
            customSqls = (List)((Map)sqlsMap.get(language)).get(type);
        }
        if (customSqls == null) {
            customSqls = new ArrayList();
        }
        return customSqls;
    }

    private void createSqlsByCustomSql(Map<String, Map<String, List<String>>> sqlsMap) {
        if (this.customSqls == null || this.customSqls.getCustomSqlList() == null) {
            return;
        }
        for (CustomSql sql : this.customSqls.getCustomSqlList()) {
            if (DataBaseUtil.isNeedCache()) {
                MetaDataFileInfo metaDataFileInfo = new MetaDataFileInfo();
                metaDataFileInfo.setType("CUSTOM_SQL");
                metaDataFileInfo.setResourceId(sql.getId());
                String timeStr = String.valueOf(this.getLastModifiedTime(sql.getId()));
                metaDataFileInfo.setModifiedTime(timeStr);
                if (!this.metaDataFileManager.createSqlAndCheckUpdate(metaDataFileInfo)) continue;
            }
            String type = sql.getType();
            for (SqlBody body : sql.getSqlBodyList()) {
                String language;
                String string = language = null == body.getDialectTypeName() ? "STANDARD_SQL_TYPE" : body.getDialectTypeName();
                String sqlStr = body.getContent();
                if (StringUtil.isEmpty((String)sqlStr)) continue;
                this.addSql(language, sqlStr, type, sqlsMap);
            }
        }
    }

    @Override
    public void addCustomSqls(CustomSqls customsqls) {
        this.customSqls = customsqls;
    }

    private void addSql(String language, String sql, String type, Map<String, Map<String, List<String>>> sqlsMap) {
        List<String> sqlList;
        Map<Object, Object> map;
        if (!sqlsMap.containsKey(language)) {
            map = new HashMap();
            sqlsMap.put(language, map);
        }
        if (!(map = sqlsMap.get(language)).containsKey(type)) {
            sqlList = new ArrayList();
            map.put(type, sqlList);
        }
        sqlList = (List)map.get(type);
        sqlList.add(sql);
    }

    @Override
    public void removeCustomSqls(CustomSqls customsqls) {
        if (customsqls == null) {
            return;
        }
        if (customsqls.getCustomSqlList() == null) {
            return;
        }
        this.customSqls = null;
    }

    @Override
    public void registerModifiedTime(CustomSqls customSqls, long lastModify) {
        for (CustomSql customSql : customSqls.getCustomSqlList()) {
            this.customSqlModifiedTimeMap.put(customSql.getId(), lastModify);
        }
    }

    @Override
    public long getLastModifiedTime(String customSqlId) {
        return this.customSqlModifiedTimeMap.get(customSqlId);
    }

    private void removeSql(String language, String sql, String type) {
    }
}

