/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.dialectfunction;

import java.util.ArrayList;
import org.tinygroup.context.Context;
import org.tinygroup.database.config.dialectfunction.Dialect;
import org.tinygroup.database.dialectfunction.DialectFunctionProcessor;
import org.tinygroup.format.FormatProvider;
import org.tinygroup.format.exception.FormatException;

public class DialectReplaceFormater
implements FormatProvider {
    private DialectFunctionProcessor processor;

    public DialectReplaceFormater(DialectFunctionProcessor processor) {
        this.processor = processor;
    }

    public String format(Context context, String string) throws FormatException {
        String databaseType = (String)context.get("databaseType");
        return this.format(string, databaseType);
    }

    private String format(String sqlFrag, String databaseType) {
        String returnStr = sqlFrag;
        int index = sqlFrag.indexOf("(");
        int endIndex = sqlFrag.lastIndexOf(")");
        if (index != -1 && endIndex != -1) {
            String functionName = sqlFrag.substring(0, index);
            String expression = sqlFrag.substring(index + 1, endIndex);
            Dialect dialect = this.processor.getDialectWithDatabaseType(functionName, databaseType);
            if (dialect != null) {
                String dialectFunctionName = dialect.getFunctionName();
                String[] params = this.analyzeFunc(expression);
                int separatorIndex = dialectFunctionName.indexOf("@");
                returnStr = separatorIndex != -1 ? this.transSqlWithMutiParam(dialectFunctionName, params, separatorIndex) : this.transSqlWithParams(dialectFunctionName, params);
            }
        }
        return returnStr;
    }

    private String transSqlWithParams(String dialectFunctionName, String[] params) {
        String returnStr = dialectFunctionName;
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            returnStr = returnStr.replaceAll("\\$" + (i + 1), param);
        }
        return returnStr;
    }

    private String transSqlWithMutiParam(String dialectFunctionName, String[] params, int separatorIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(dialectFunctionName.substring(0, separatorIndex));
        int separatorEndIndex = dialectFunctionName.indexOf(")");
        String separator = dialectFunctionName.substring(separatorIndex + 1, separatorEndIndex);
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            buffer.append(param);
            if (i == params.length - 1) continue;
            buffer.append(separator);
        }
        buffer.append(dialectFunctionName.substring(separatorEndIndex, dialectFunctionName.length()));
        return buffer.toString();
    }

    private String[] analyzeFunc(String srcSql) {
        ArrayList<String> paraList = new ArrayList<String>();
        boolean markers = false;
        StringBuilder sb = new StringBuilder();
        char[] sqlCharArray = srcSql.toCharArray();
        for (int i = 0; i < sqlCharArray.length; ++i) {
            if (sqlCharArray[i] == '(') {
                markers = true;
            }
            if (markers && ')' == sqlCharArray[i]) {
                markers = false;
            }
            if (sqlCharArray[i] == ',' && !markers) {
                paraList.add(sb.toString().trim());
                sb = new StringBuilder();
            } else {
                sb.append(sqlCharArray[i]);
            }
            if (i != sqlCharArray.length - 1) continue;
            paraList.add(sb.toString().trim());
        }
        return paraList.toArray(new String[0]);
    }
}

