/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.dialectfunction.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.database.config.dialectfunction.Dialect;
import org.tinygroup.database.config.dialectfunction.DialectFunction;
import org.tinygroup.database.config.dialectfunction.DialectFunctions;
import org.tinygroup.database.dialectfunction.DialectFunctionProcessor;
import org.tinygroup.database.dialectfunction.DialectReplaceFormater;
import org.tinygroup.format.FormatProvider;
import org.tinygroup.format.Formater;
import org.tinygroup.format.PatternDefine;
import org.tinygroup.format.impl.DefaultPatternDefine;
import org.tinygroup.format.impl.FormaterImpl;

public class DialectFunctionProcessorImpl
implements DialectFunctionProcessor {
    private Map<String, DialectFunction> dialectMap = new HashMap<String, DialectFunction>();
    private Map<String, List<Dialect>> database2Dialects = new HashMap<String, List<Dialect>>();
    private Formater formatter;

    @Override
    public void addDialectFunctions(DialectFunctions functions) {
        List<DialectFunction> dialectFunctions = functions.getFunctions();
        for (DialectFunction dialectFunction : dialectFunctions) {
            List<Dialect> dialects = dialectFunction.getDialects();
            for (Dialect dialect : dialects) {
                List<Dialect> dialectList = this.database2Dialects.get(dialect.getName());
                if (dialectList == null) {
                    dialectList = new ArrayList<Dialect>();
                    this.database2Dialects.put(dialect.getName(), dialectList);
                }
                dialectList.add(dialect);
            }
            this.dialectMap.put(dialectFunction.getName(), dialectFunction);
        }
    }

    @Override
    public void removeDialectFunctions(DialectFunctions functions) {
        List<DialectFunction> dialectFunctions = functions.getFunctions();
        for (DialectFunction dialectFunction : dialectFunctions) {
            List<Dialect> dialects = dialectFunction.getDialects();
            for (Dialect dialect : dialects) {
                List<Dialect> dialectList = this.database2Dialects.get(dialect.getName());
                if (CollectionUtil.isEmpty(dialectList)) continue;
                dialectList.remove(dialect);
            }
            this.dialectMap.remove(dialectFunction.getName());
        }
    }

    @Override
    public DialectFunction getDialectFunction(String functionName) {
        return this.dialectMap.get(functionName);
    }

    @Override
    @Deprecated
    public String getFuntionSql(String originalSql, String databaseType) {
        return this.getFunctionSql(originalSql, databaseType);
    }

    @Override
    public String getFunctionSql(String originalSql, String databaseType) {
        if (this.formatter == null) {
            this.initFormater();
        }
        ContextImpl context = new ContextImpl();
        context.put("databaseType", (Object)databaseType);
        String beforeFormater = originalSql;
        String afterFormater = this.formatter.format((Context)context, beforeFormater);
        while (!beforeFormater.equals(afterFormater)) {
            beforeFormater = afterFormater;
            afterFormater = this.formatter.format((Context)context, beforeFormater);
        }
        return afterFormater;
    }

    @Override
    public Dialect getDialectWithDatabaseType(String functionName, String databaseType) {
        DialectFunction function = this.getDialectFunction(functionName);
        List<Dialect> dialects = function.getDialects();
        if (dialects != null) {
            for (Dialect dialect : dialects) {
                if (!dialect.getName().equalsIgnoreCase(databaseType)) continue;
                return dialect;
            }
        }
        return null;
    }

    private void initFormater() {
        this.formatter = new FormaterImpl();
        DefaultPatternDefine define = new DefaultPatternDefine();
        define.setPrefixPatternString("#{");
        define.setPostfixPatternString("}");
        define.setPatternString("([#][{]([^#{}]*)[}])");
        this.formatter.setPatternHandle((PatternDefine)define);
        DialectReplaceFormater replace = new DialectReplaceFormater(this);
        this.formatter.addFormatProvider("", (FormatProvider)replace);
    }
}

