/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.database.config.customsql.CustomSqls;
import org.tinygroup.database.customesql.CustomSqlProcessor;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class CustomSqlFileResolver
extends AbstractFileProcessor {
    private static final String CUSTOMSQL_EXTFILENAME = ".customsql.xml";
    CustomSqlProcessor customSqlProcessor;

    public CustomSqlProcessor getCustomSqlProcessor() {
        return this.customSqlProcessor;
    }

    public void setCustomSqlProcessor(CustomSqlProcessor customSqlProcessor) {
        this.customSqlProcessor = customSqlProcessor;
    }

    public void process() {
        CustomSqls customsqls;
        XStream stream = XStreamFactory.getXStream((String)DataBaseUtil.DATABASE_XSTREAM);
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664customsql\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            customsqls = (CustomSqls)this.caches.get(fileObject.getAbsolutePath());
            if (customsqls != null) {
                this.customSqlProcessor.removeCustomSqls(customsqls);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664customsql\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dcustomsql\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            customsqls = (CustomSqls)stream.fromXML(fileObject.getInputStream());
            CustomSqls oldCustomsqls = (CustomSqls)this.caches.get(fileObject.getAbsolutePath());
            if (oldCustomsqls != null) {
                this.customSqlProcessor.removeCustomSqls(oldCustomsqls);
            }
            this.customSqlProcessor.addCustomSqls(customsqls);
            this.caches.put(fileObject.getAbsolutePath(), customsqls);
            this.customSqlProcessor.registerModifiedTime(customsqls, fileObject.getLastModifiedTime());
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dcustomsql\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(CUSTOMSQL_EXTFILENAME) || fileObject.getFileName().endsWith(".customsql");
    }
}

