/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.database.config.dialectfunction.DialectFunctions;
import org.tinygroup.database.dialectfunction.DialectFunctionProcessor;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class DialectFunctionlFileResolver
extends AbstractFileProcessor {
    private static final String FUNCTION_EXTFILENAME = ".dialectfunction.xml";
    DialectFunctionProcessor functionProcessor;

    public DialectFunctionProcessor getFunctionProcessor() {
        return this.functionProcessor;
    }

    public void setFunctionProcessor(DialectFunctionProcessor functionProcessor) {
        this.functionProcessor = functionProcessor;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)DataBaseUtil.DATABASE_XSTREAM);
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664function\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            DialectFunctions functions = (DialectFunctions)this.caches.get(fileObject.getAbsolutePath());
            if (functions != null) {
                this.functionProcessor.removeDialectFunctions(functions);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664function\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dfunction\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            DialectFunctions oldFunctions = (DialectFunctions)this.caches.get(fileObject.getAbsolutePath());
            if (oldFunctions != null) {
                this.functionProcessor.removeDialectFunctions(oldFunctions);
            }
            DialectFunctions functions = (DialectFunctions)stream.fromXML(fileObject.getInputStream());
            this.functionProcessor.addDialectFunctions(functions);
            this.caches.put(fileObject.getAbsolutePath(), functions);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dfunction\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(FUNCTION_EXTFILENAME);
    }
}

