/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.database.config.initdata.InitDatas;
import org.tinygroup.database.initdata.InitDataProcessor;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class InitDataFileResolver
extends AbstractFileProcessor {
    private static final String INITDATA_EXTFILENAME = ".initdata.xml";
    InitDataProcessor initDataProcessor;

    public InitDataProcessor getInitDataProcessor() {
        return this.initDataProcessor;
    }

    public void setInitDataProcessor(InitDataProcessor initDataProcessor) {
        this.initDataProcessor = initDataProcessor;
    }

    public void process() {
        LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u5904\u7406\u8868\u683c\u521d\u59cb\u5316\u6570\u636einit\u6587\u4ef6");
        XStream stream = XStreamFactory.getXStream((String)DataBaseUtil.INITDATA_XSTREAM);
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u8bfb\u53d6\u8868\u683c\u521d\u59cb\u5316\u6570\u636einit\u6587\u4ef6{0}", new Object[]{fileObject.getAbsolutePath().toString()});
            InitDatas initDatas = (InitDatas)this.caches.get(fileObject.getAbsolutePath());
            if (initDatas != null) {
                this.initDataProcessor.removeInitDatas(initDatas);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6\u8868\u683c\u521d\u59cb\u5316\u6570\u636einit\u6587\u4ef6{0}\u5b8c\u6bd5", new Object[]{fileObject.getAbsolutePath().toString()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u8bfb\u53d6\u8868\u683c\u521d\u59cb\u5316\u6570\u636einit\u6587\u4ef6{0}", new Object[]{fileObject.getAbsolutePath().toString()});
            InitDatas oldInitDatas = (InitDatas)this.caches.get(fileObject.getAbsolutePath());
            if (oldInitDatas != null) {
                this.initDataProcessor.removeInitDatas(oldInitDatas);
            }
            InitDatas initDatas = (InitDatas)stream.fromXML(fileObject.getInputStream());
            this.initDataProcessor.addInitDatas(initDatas);
            this.caches.put(fileObject.getAbsolutePath(), initDatas);
            this.initDataProcessor.registerModifiedTime(initDatas, fileObject.getLastModifiedTime());
            LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6\u8868\u683c\u521d\u59cb\u5316\u6570\u636einit\u6587\u4ef6{0}\u5b8c\u6bd5", new Object[]{fileObject.getAbsolutePath().toString()});
        }
        LOGGER.logMessage(LogLevel.INFO, "\u5904\u7406\u8868\u683c\u521d\u59cb\u5316\u6570\u636einit\u6587\u4ef6\u8bfb\u53d6\u5b8c\u6bd5");
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(INITDATA_EXTFILENAME) || fileObject.getFileName().endsWith(".initdata");
    }
}

