/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.database.config.procedure.Procedures;
import org.tinygroup.database.procedure.ProcedureProcessor;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class ProcedureFileResolver
extends AbstractFileProcessor {
    private static final String PROCEDURE_EXTFILENAME = ".procedure.xml";
    ProcedureProcessor procedureProcessor;

    public ProcedureProcessor getProcedureProcessor() {
        return this.procedureProcessor;
    }

    public void setProcedureProcessor(ProcedureProcessor procedureProcessor) {
        this.procedureProcessor = procedureProcessor;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)DataBaseUtil.DATABASE_XSTREAM);
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664procedure\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Procedures procedures = (Procedures)this.caches.get(fileObject.getAbsolutePath());
            if (procedures != null) {
                this.procedureProcessor.removeProcedures(procedures);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664procedure\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dprocedure\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Procedures oldProcedures = (Procedures)this.caches.get(fileObject.getAbsolutePath());
            if (oldProcedures != null) {
                this.procedureProcessor.removeProcedures(oldProcedures);
            }
            Procedures procedures = (Procedures)stream.fromXML(fileObject.getInputStream());
            this.procedureProcessor.addProcedures(procedures);
            this.caches.put(fileObject.getAbsolutePath(), procedures);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dprocedure\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(PROCEDURE_EXTFILENAME) || fileObject.getFileName().endsWith(".procedure");
    }
}

