/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.database.ProcessorManager;
import org.tinygroup.database.config.processor.Processors;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class ProcessorFileResolver
extends AbstractFileProcessor {
    private static final String PROCESSOR_EXTFILENAME = ".database.processor.xml";
    ProcessorManager processorManager;

    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    public void setProcessorManager(ProcessorManager processorManager) {
        this.processorManager = processorManager;
    }

    public void process() {
        LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u8bfb\u53d6database.processor\u6587\u4ef6");
        XStream stream = XStreamFactory.getXStream((String)DataBaseUtil.PROCESSOR_XSTREAM);
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u79fb\u9664database.processor\u6587\u4ef6{0}", new Object[]{fileObject.getAbsolutePath()});
            Processors processors = (Processors)this.caches.get(fileObject.getAbsolutePath());
            if (processors != null) {
                this.processorManager.removeProcessors(processors);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664database.processor\u6587\u4ef6{0}\u5b8c\u6bd5", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u8bfb\u53d6database.processor\u6587\u4ef6{0}", new Object[]{fileObject.getAbsolutePath()});
            Processors oldProcessors = (Processors)this.caches.get(fileObject.getAbsolutePath());
            if (oldProcessors != null) {
                this.processorManager.removeProcessors(oldProcessors);
            }
            Processors processors = (Processors)stream.fromXML(fileObject.getInputStream());
            this.processorManager.addProcessors(processors);
            this.caches.put(fileObject.getAbsolutePath(), processors);
            LOGGER.logMessage(LogLevel.INFO, "\u8bfb\u53d6database.processor\u6587\u4ef6{0}\u5b8c\u6bd5", new Object[]{fileObject.getAbsolutePath()});
        }
        LOGGER.logMessage(LogLevel.INFO, "database.processor\u6587\u4ef6\u8bfb\u53d6\u5b8c\u6bd5");
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(PROCESSOR_EXTFILENAME);
    }
}

