/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.database.config.sequence.Sequences;
import org.tinygroup.database.sequence.SequenceProcessor;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class SequenceFileProcessor
extends AbstractFileProcessor {
    private static final String TRIGGER_EXTFILENAME = ".sequence.xml";
    SequenceProcessor processor;

    public SequenceProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(SequenceProcessor processor) {
        this.processor = processor;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)DataBaseUtil.DATABASE_XSTREAM);
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664sequence\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Sequences sequences = (Sequences)this.caches.get(fileObject.getAbsolutePath());
            if (sequences != null) {
                this.processor.removeSequences(sequences);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664sequence\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dsequence\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Sequences oldSequences = (Sequences)this.caches.get(fileObject.getAbsolutePath());
            if (oldSequences != null) {
                this.processor.removeSequences(oldSequences);
            }
            Sequences sequences = (Sequences)stream.fromXML(fileObject.getInputStream());
            this.processor.addSequences(sequences);
            this.caches.put(fileObject.getAbsolutePath(), sequences);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dsequence\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(TRIGGER_EXTFILENAME);
    }
}

