/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.database.config.table.Tables;
import org.tinygroup.database.table.TableProcessor;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class TableFileResolver
extends AbstractFileProcessor {
    private static final String TABLE_EXTFILENAME = ".table.xml";
    TableProcessor tableProcessor;

    public TableProcessor getTableProcessor() {
        return this.tableProcessor;
    }

    public void setTableProcessor(TableProcessor tableProcessor) {
        this.tableProcessor = tableProcessor;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)DataBaseUtil.DATABASE_XSTREAM);
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664table\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Tables tables = (Tables)((Object)this.caches.get(fileObject.getAbsolutePath()));
            if (tables != null) {
                this.tableProcessor.removeTables(tables);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664table\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dtable\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Tables oldTables = (Tables)((Object)this.caches.get(fileObject.getAbsolutePath()));
            if (oldTables != null) {
                this.tableProcessor.removeTables(oldTables);
            }
            Tables tables = (Tables)((Object)stream.fromXML(fileObject.getInputStream()));
            this.tableProcessor.addTables(tables);
            this.caches.put(fileObject.getAbsolutePath(), tables);
            this.tableProcessor.registerModifiedTime(tables, fileObject.getLastModifiedTime());
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dtable\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(TABLE_EXTFILENAME) || fileObject.getFileName().endsWith(".table");
    }
}

