/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.database.config.tablespace.TableSpaces;
import org.tinygroup.database.tablespace.TableSpaceProcessor;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class TableSpaceFileResolver
extends AbstractFileProcessor {
    private static final String CUSTOMSQL_EXTFILENAME = ".tablespace.xml";
    private TableSpaceProcessor tableSpaceProcessor;

    public TableSpaceProcessor getTableSpaceProcessor() {
        return this.tableSpaceProcessor;
    }

    public void setTableSpaceProcessor(TableSpaceProcessor tableSpaceProcessor) {
        this.tableSpaceProcessor = tableSpaceProcessor;
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(CUSTOMSQL_EXTFILENAME) || fileObject.getFileName().endsWith(".tablespace");
    }

    public void process() {
        TableSpaces tableSpaces;
        XStream stream = XStreamFactory.getXStream((String)DataBaseUtil.DATABASE_XSTREAM);
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664tablespace\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            tableSpaces = (TableSpaces)((Object)this.caches.get(fileObject.getAbsolutePath()));
            if (tableSpaces != null) {
                this.tableSpaceProcessor.removeTableSpaces(tableSpaces);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664tablespace\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dtablespace\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            tableSpaces = (TableSpaces)((Object)stream.fromXML(fileObject.getInputStream()));
            TableSpaces oldTableSpaces = (TableSpaces)((Object)this.caches.get(fileObject.getAbsolutePath()));
            if (oldTableSpaces != null) {
                this.tableSpaceProcessor.removeTableSpaces(oldTableSpaces);
            }
            this.tableSpaceProcessor.addTableSpaces(tableSpaces);
            this.caches.put(fileObject.getAbsolutePath(), tableSpaces);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dtablespace\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

