/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.database.config.trigger.Triggers;
import org.tinygroup.database.trigger.TriggerProcessor;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class TriggerFileProcessor
extends AbstractFileProcessor {
    private static final String TRIGGER_EXTFILENAME = ".trigger.xml";
    TriggerProcessor processor;

    public TriggerProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(TriggerProcessor processor) {
        this.processor = processor;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)DataBaseUtil.DATABASE_XSTREAM);
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664trigger\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Triggers triggers = (Triggers)this.caches.get(fileObject.getAbsolutePath());
            if (triggers != null) {
                this.processor.removeTriggers(triggers);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664trigger\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dtrigger\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Triggers oldTriggers = (Triggers)this.caches.get(fileObject.getAbsolutePath());
            if (oldTriggers != null) {
                this.processor.removeTriggers(oldTriggers);
            }
            Triggers triggers = (Triggers)stream.fromXML(fileObject.getInputStream());
            this.processor.addTriggers(triggers);
            this.caches.put(fileObject.getAbsolutePath(), triggers);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dtrigger\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(TRIGGER_EXTFILENAME);
    }
}

