/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.database.config.view.Views;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.database.view.ViewProcessor;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class ViewFileResolver
extends AbstractFileProcessor {
    private static final String VIEW_EXTFILENAME = ".view.xml";
    ViewProcessor viewProcessor;

    public ViewProcessor getViewProcessor() {
        return this.viewProcessor;
    }

    public void setViewProcessor(ViewProcessor viewProcessor) {
        this.viewProcessor = viewProcessor;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)DataBaseUtil.DATABASE_XSTREAM);
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664view\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Views views = (Views)((Object)this.caches.get(fileObject.getAbsolutePath()));
            if (views != null) {
                this.viewProcessor.removeViews(views);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664view\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dview\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Views oldViews = (Views)((Object)this.caches.get(fileObject.getAbsolutePath()));
            if (oldViews != null) {
                this.viewProcessor.removeViews(oldViews);
            }
            Views views = (Views)((Object)stream.fromXML(fileObject.getInputStream()));
            this.viewProcessor.addViews(views);
            this.caches.put(fileObject.getAbsolutePath(), views);
            this.viewProcessor.registerModifiedTime(views, fileObject.getLastModifiedTime());
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dview\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        this.viewProcessor.dependencyInit();
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(VIEW_EXTFILENAME) || fileObject.getFileName().endsWith(".view");
    }
}

