/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.database.ProcessorManager;
import org.tinygroup.database.config.processor.Processor;
import org.tinygroup.database.config.processor.Processors;
import org.tinygroup.database.initdata.impl.InitDataSqlProcessorImpl;
import org.tinygroup.database.initdata.impl.MySqlInitDataSqlProcessorImpl;
import org.tinygroup.database.initdata.impl.OracleInitDataSqlProcessorImpl;
import org.tinygroup.database.procedure.impl.Db2ProcedureSqlProcessorImpl;
import org.tinygroup.database.procedure.impl.DerbyProcedureSqlProcessorImpl;
import org.tinygroup.database.procedure.impl.H2ProcedureSqlProcessorImpl;
import org.tinygroup.database.procedure.impl.MySqlProcedureSqlProcessorImpl;
import org.tinygroup.database.procedure.impl.OracleProcedureSqlProcessorImpl;
import org.tinygroup.database.procedure.impl.SqlServerProcedureSqlProcessorImpl;
import org.tinygroup.database.sequence.impl.Db2SequenceSqlProcessor;
import org.tinygroup.database.sequence.impl.OracleSequenceSqlProcessor;
import org.tinygroup.database.table.impl.Db2SqlProcessorImpl;
import org.tinygroup.database.table.impl.DerbySqlProcessorImpl;
import org.tinygroup.database.table.impl.H2SqlProcessorImpl;
import org.tinygroup.database.table.impl.MysqlSqlProcessorImpl;
import org.tinygroup.database.table.impl.OracleSqlProcessorImpl;
import org.tinygroup.database.table.impl.SqlserverSqlProcessorImpl;
import org.tinygroup.database.trigger.impl.MysqlTriggerSqlProcessor;
import org.tinygroup.database.trigger.impl.OracleTriggerSqlProcessor;
import org.tinygroup.database.trigger.impl.SqlServerTriggerSqlProcessor;
import org.tinygroup.database.view.impl.Db2ViewSqlProcessorImpl;
import org.tinygroup.database.view.impl.DerbyViewSqlProcessorImpl;
import org.tinygroup.database.view.impl.H2ViewSqlProcessorImpl;
import org.tinygroup.database.view.impl.MysqlViewSqlProcessorImpl;
import org.tinygroup.database.view.impl.OracleViewSqlProcessorImpl;
import org.tinygroup.database.view.impl.SqlserverViewSqlProcessorImpl;

public class ProcessorManagerImpl
implements ProcessorManager {
    private static ProcessorManager processorManager = new ProcessorManagerImpl();
    private Map<String, Map<String, Object>> processorsMap = new HashMap<String, Map<String, Object>>();

    public static ProcessorManager getProcessorManager() {
        ProcessorManagerImpl.managerInit((ProcessorManagerImpl)processorManager);
        return processorManager;
    }

    private static void managerInit(ProcessorManagerImpl processorManager) {
        InitDataSqlProcessorImpl initDataSqlProcessor = new InitDataSqlProcessorImpl();
        OracleInitDataSqlProcessorImpl oracleInitDataSqlProcessor = new OracleInitDataSqlProcessorImpl();
        MySqlInitDataSqlProcessorImpl mysqlInitDataSqlProcessor = new MySqlInitDataSqlProcessorImpl();
        Map<String, Map<String, Object>> processorsMap = processorManager.processorsMap;
        HashMap<String, Object> db2ProcessMap = new HashMap<String, Object>();
        db2ProcessMap.put("table", Db2SqlProcessorImpl.getTableSqlProcessor());
        db2ProcessMap.put("initData", initDataSqlProcessor);
        db2ProcessMap.put("view", new Db2ViewSqlProcessorImpl());
        db2ProcessMap.put("sequence", new Db2SequenceSqlProcessor());
        db2ProcessMap.put("procedure", new Db2ProcedureSqlProcessorImpl());
        processorsMap.put("db2", db2ProcessMap);
        HashMap<String, Object> derbyProcessMap = new HashMap<String, Object>();
        derbyProcessMap.put("table", DerbySqlProcessorImpl.getTableSqlProcessor());
        derbyProcessMap.put("initData", initDataSqlProcessor);
        derbyProcessMap.put("view", new DerbyViewSqlProcessorImpl());
        derbyProcessMap.put("procedure", new DerbyProcedureSqlProcessorImpl());
        processorsMap.put("derby", derbyProcessMap);
        HashMap<String, Object> h2ProcessMap = new HashMap<String, Object>();
        h2ProcessMap.put("table", H2SqlProcessorImpl.getTableSqlProcessor());
        h2ProcessMap.put("initData", initDataSqlProcessor);
        h2ProcessMap.put("view", new H2ViewSqlProcessorImpl());
        h2ProcessMap.put("procedure", new H2ProcedureSqlProcessorImpl());
        processorsMap.put("h2", h2ProcessMap);
        HashMap<String, Object> mysqlProcessMap = new HashMap<String, Object>();
        mysqlProcessMap.put("table", MysqlSqlProcessorImpl.getTableSqlProcessor());
        mysqlProcessMap.put("initData", mysqlInitDataSqlProcessor);
        mysqlProcessMap.put("view", new MysqlViewSqlProcessorImpl());
        mysqlProcessMap.put("procedure", new MySqlProcedureSqlProcessorImpl());
        mysqlProcessMap.put("trigger", new MysqlTriggerSqlProcessor());
        processorsMap.put("mysql", mysqlProcessMap);
        HashMap<String, Object> oracleProcessMap = new HashMap<String, Object>();
        oracleProcessMap.put("table", OracleSqlProcessorImpl.getTableSqlProcessor());
        oracleProcessMap.put("initData", oracleInitDataSqlProcessor);
        oracleProcessMap.put("view", new OracleViewSqlProcessorImpl());
        oracleProcessMap.put("procedure", new OracleProcedureSqlProcessorImpl());
        oracleProcessMap.put("sequence", new OracleSequenceSqlProcessor());
        oracleProcessMap.put("trigger", new OracleTriggerSqlProcessor());
        processorsMap.put("oracle", oracleProcessMap);
        HashMap<String, Object> sqlserverSqlProcessMap = new HashMap<String, Object>();
        sqlserverSqlProcessMap.put("table", SqlserverSqlProcessorImpl.getTableSqlProcessor());
        sqlserverSqlProcessMap.put("initData", initDataSqlProcessor);
        sqlserverSqlProcessMap.put("view", new SqlserverViewSqlProcessorImpl());
        sqlserverSqlProcessMap.put("trigger", new SqlServerTriggerSqlProcessor());
        sqlserverSqlProcessMap.put("procedure", new SqlServerProcedureSqlProcessorImpl());
        processorsMap.put("sqlserver", sqlserverSqlProcessMap);
    }

    @Override
    @Deprecated
    public void addPocessors(Processors processors) {
        this.addProcessors(processors);
    }

    @Override
    @Deprecated
    public void removePocessors(Processors processors) {
        this.removeProcessors(processors);
    }

    @Override
    public void addProcessors(Processors processors) {
        String language = processors.getLanguage();
        if (!this.processorsMap.containsKey(language)) {
            this.processorsMap.put(language, new HashMap());
        }
        Map<String, Object> map = this.processorsMap.get(language);
        for (Processor processor : processors.getList()) {
            String processorName = processor.getName();
            String bean = processor.getBean();
            map.put(processorName, BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(bean));
        }
    }

    @Override
    public void removeProcessors(Processors processors) {
        String language = processors.getLanguage();
        Map<String, Object> map = this.processorsMap.get(language);
        if (!CollectionUtil.isEmpty(map)) {
            for (Processor processor : processors.getList()) {
                String processorName = processor.getName();
                map.remove(processorName);
            }
        }
    }

    @Override
    public Object getProcessor(String language, String name) {
        if (this.processorsMap.containsKey(language)) {
            return this.processorsMap.get(language).get(name);
        }
        return null;
    }
}

