/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.initdata.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.database.ProcessorManager;
import org.tinygroup.database.config.initdata.InitData;
import org.tinygroup.database.config.initdata.InitDatas;
import org.tinygroup.database.config.table.Table;
import org.tinygroup.database.initdata.InitDataProcessor;
import org.tinygroup.database.initdata.InitDataSqlProcessor;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.metadata.checkupdate.MetaDataFileInfo;
import org.tinygroup.metadata.checkupdate.MetaDataFileManager;
import org.tinygroup.metadata.util.MetadataUtil;

public class InitDataProcessorImpl
implements InitDataProcessor {
    private static InitDataProcessor initDataProcessor = new InitDataProcessorImpl();
    private static Logger logger = LoggerFactory.getLogger(InitDataProcessorImpl.class);
    protected MetaDataFileManager metaDataFileManager = MetaDataFileManager.getInstance();
    private Map<String, List<InitData>> initDatasIdMap = new HashMap<String, List<InitData>>();
    private Map<String, List<InitData>> initDatasNameMap = new HashMap<String, List<InitData>>();
    private Map<String, Long> initDataModifiedTimeMap = new HashMap<String, Long>();
    private ProcessorManager processorManager;

    public static InitDataProcessor getInitDataProcessor() {
        return initDataProcessor;
    }

    @Override
    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    @Override
    public void setProcessorManager(ProcessorManager processorManager) {
        this.processorManager = processorManager;
    }

    @Override
    public List<String> getInitSql(String packageName, String tableName, String language) {
        List<InitData> tableInitDataList = this.getInitDataList(packageName, tableName);
        return this.getInitSql(tableInitDataList, language);
    }

    @Override
    public List<String> getInitSql(String tableName, String language) {
        return this.getInitSql(null, tableName, language);
    }

    @Override
    public List<String> getInitSqlByTableId(String tableId, String language) {
        List<InitData> tableInitDataList = this.getInitDataListByTableId(tableId);
        return this.getInitSql(tableInitDataList, language);
    }

    @Override
    public List<String> getInitSql(String language) throws SQLException {
        ArrayList<String> doList = new ArrayList<String>();
        doList.addAll(this.getDeInitSql(language));
        InitDataSqlProcessor sqlProcessor = (InitDataSqlProcessor)this.processorManager.getProcessor(language, "initData");
        List<Table> allOrderTables = DataBaseUtil.getTables(this.getClass().getClassLoader());
        for (Table table : allOrderTables) {
            List<InitData> tableInitDataList = this.initDatasIdMap.get(table.getId());
            if (tableInitDataList == null) continue;
            for (InitData initData : tableInitDataList) {
                if (!this.isNeedUpdate(initData)) continue;
                doList.addAll(sqlProcessor.getInitSql(initData));
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        if (doList.size() > 0) {
            list.addAll(sqlProcessor.getPreInitSql(allOrderTables));
            list.addAll(doList);
            list.addAll(sqlProcessor.getPostInitSql(allOrderTables));
        }
        return list;
    }

    private boolean isNeedUpdate(InitData initData) {
        if (DataBaseUtil.isNeedCache()) {
            MetaDataFileInfo metaDataFileInfo = new MetaDataFileInfo();
            metaDataFileInfo.setType("INIT_DATA");
            metaDataFileInfo.setResourceId(initData.getId());
            String timeStr = String.valueOf(this.initDataModifiedTimeMap.get(initData.getId()));
            metaDataFileInfo.setModifiedTime(timeStr);
            return this.metaDataFileManager.createSqlAndCheckUpdate(metaDataFileInfo);
        }
        return true;
    }

    private List<String> getInitSql(List<InitData> tableInitDataList, String language) {
        ArrayList<String> sqls = new ArrayList<String>();
        InitDataSqlProcessor sqlProcessor = (InitDataSqlProcessor)this.processorManager.getProcessor(language, "initData");
        for (InitData initData : tableInitDataList) {
            sqls.addAll(sqlProcessor.getInitSql(initData));
        }
        return sqls;
    }

    @Override
    public void addInitDatas(InitDatas initDatas) {
        logger.logMessage(LogLevel.DEBUG, "\u5f00\u59cb\u6dfb\u52a0\u8868\u683c\u521d\u59cb\u6570\u636e");
        if (initDatas == null || initDatas.getInitDataList() == null) {
            logger.logMessage(LogLevel.DEBUG, "\u4f20\u5165\u7684\u521d\u59cb\u6570\u636e\u4e3a\u7a7a\uff0c\u6570\u636e\u6dfb\u52a0\u7ed3\u675f\u3002");
            return;
        }
        for (InitData initData : initDatas.getInitDataList()) {
            this.addInitData(initData);
        }
        logger.logMessage(LogLevel.DEBUG, "\u8868\u683c\u521d\u59cb\u6570\u636e\u6dfb\u52a0\u5b8c\u6bd5");
    }

    @Override
    public void removeInitDatas(InitDatas initDatas) {
        logger.logMessage(LogLevel.DEBUG, "\u5f00\u59cb\u6dfb\u52a0\u8868\u683c\u521d\u59cb\u6570\u636e");
        if (initDatas == null || initDatas.getInitDataList() == null) {
            logger.logMessage(LogLevel.DEBUG, "\u4f20\u5165\u7684\u521d\u59cb\u6570\u636e\u4e3a\u7a7a\uff0c\u6570\u636e\u6dfb\u52a0\u7ed3\u675f\u3002");
            return;
        }
        for (InitData initData : initDatas.getInitDataList()) {
            this.removeInitData(initData);
        }
        logger.logMessage(LogLevel.DEBUG, "\u8868\u683c\u521d\u59cb\u6570\u636e\u6dfb\u52a0\u5b8c\u6bd5");
    }

    private void removeInitData(InitData initData) {
        List<InitData> tableInitDataList;
        String tableId = MetadataUtil.passNull((String)initData.getTableId());
        String tableName = DataBaseUtil.getTableById(tableId, this.getClass().getClassLoader()).getName();
        logger.logMessage(LogLevel.DEBUG, "\u5f00\u59cb\u79fb\u9664\u8868\u683c[\u8868\u540d:{0},\u8868ID:{1}]\u7684\u521d\u59cb\u5316\u6570\u636e", new Object[]{tableName, tableId});
        if (!CollectionUtil.isEmpty(this.initDatasIdMap) && (tableInitDataList = this.initDatasIdMap.get(tableName)) != null) {
            for (InitData tableInitData : tableInitDataList) {
                tableInitData.getRecordList().removeAll(initData.getRecordList());
            }
        }
        this.initDatasNameMap.remove(tableName);
        this.initDatasIdMap.remove(tableId);
        logger.logMessage(LogLevel.DEBUG, "\u79fb\u9664\u8868\u683c[\u8868\u540d:{0},\u8868ID:{1}]\u7684\u521d\u59cb\u5316\u6570\u636e\u5b8c\u6bd5", new Object[]{tableName, tableId});
    }

    private void addInitData(InitData initData) {
        String tableId = MetadataUtil.passNull((String)initData.getTableId());
        Table table = DataBaseUtil.getTableById(tableId, this.getClass().getClassLoader());
        if (table == null) {
            throw new RuntimeException("\u8868\u683c" + initData.getTableId() + "\u4e0d\u5b58\u5728");
        }
        String tableName = table.getName();
        logger.logMessage(LogLevel.DEBUG, "\u5f00\u59cb\u4e3a\u8868\u683c[\u8868\u540d:{0},\u8868ID:{1}]\u6dfb\u52a0\u521d\u59cb\u5316\u6570\u636e", new Object[]{tableName, tableId});
        List<Object> initDataList = new ArrayList();
        if (this.initDatasIdMap.containsKey(tableId)) {
            initDataList = this.initDatasIdMap.get(tableId);
        }
        InitData tableInitData = new InitData();
        tableInitData.setTableId(tableId);
        tableInitData.setId(initData.getId());
        tableInitData.setRecordList(initData.getRecordList());
        initDataList.add((Object)tableInitData);
        this.initDatasIdMap.put(tableId, initDataList);
        this.initDatasNameMap.put(tableName, initDataList);
        tableInitData.getRecordList().addAll(initData.getRecordList());
        logger.logMessage(LogLevel.DEBUG, "\u8868\u683c[\u8868\u540d:{0},\u8868ID:{1}]\u6dfb\u52a0\u521d\u59cb\u5316\u6570\u636e\u5b8c\u6bd5", new Object[]{tableName, tableId});
    }

    @Override
    public List<InitData> getInitDataList(String tableName) {
        return this.getInitDataList("", tableName);
    }

    @Override
    public List<InitData> getInitDataListByTableId(String tableId) {
        return this.initDatasIdMap.get(tableId);
    }

    @Override
    public List<InitData> getInitDataList(String packageName, String tableName) {
        String realTableName = MetadataUtil.passNull((String)tableName);
        logger.logMessage(LogLevel.DEBUG, "\u83b7\u53d6\u8868\u683c[\u8868\u540d:{0}]\u521d\u59cb\u5316\u6570\u636e", new Object[]{realTableName});
        if (this.initDatasNameMap.containsKey(tableName)) {
            logger.logMessage(LogLevel.DEBUG, "\u6210\u529f\u83b7\u53d6\u8868\u683c[\u8868\u540d:{0}]\u521d\u59cb\u5316\u6570\u636e", new Object[]{realTableName});
            return this.initDatasNameMap.get(realTableName);
        }
        logger.logMessage(LogLevel.DEBUG, "[\u5305:{0}]\u4e0b\u672a\u627e\u5230[\u8868\u540d:{0}]\u7684\u521d\u59cb\u5316\u6570\u636e", new Object[]{realTableName});
        if (this.initDatasNameMap.containsKey(realTableName)) {
            List<InitData> initDataList = this.initDatasNameMap.get(realTableName);
            logger.logMessage(LogLevel.DEBUG, "\u6210\u529f\u83b7\u53d6\u8868\u683c[\u5305:{0},\u8868\u540d:{1}]\u521d\u59cb\u5316\u6570\u636e", new Object[]{realTableName});
            return initDataList;
        }
        throw new RuntimeException(String.format("\u83b7\u53d6\u8868\u683c[\u8868\u540d:%s]\u521d\u59cb\u5316\u6570\u636e\u5931\u8d25", realTableName));
    }

    @Override
    public List<String> getDeInitSql(String packageName, String tableName, String language) {
        List<InitData> tableInitDataList = this.getInitDataList(packageName, tableName);
        ArrayList<String> sqls = new ArrayList<String>();
        for (InitData initData : tableInitDataList) {
            sqls.addAll(this.getDeInitSql(initData, language));
        }
        return sqls;
    }

    @Override
    public List<String> getDeInitSql(String tableName, String language) {
        return this.getDeInitSql(null, tableName, language);
    }

    @Override
    public List<String> getDeInitSql(String language) {
        ArrayList<String> list = new ArrayList<String>();
        InitDataSqlProcessor sqlProcessor = (InitDataSqlProcessor)this.processorManager.getProcessor(language, "initData");
        List<Table> allOrderTables = DataBaseUtil.getTables(this.getClass().getClassLoader());
        if (allOrderTables.size() == 0) {
            return list;
        }
        for (int i = allOrderTables.size() - 1; i >= 0; --i) {
            Table table = allOrderTables.get(i);
            List<InitData> tableInitDataList = this.initDatasIdMap.get(table.getId());
            if (tableInitDataList == null) continue;
            for (InitData tableInitData : tableInitDataList) {
                if (!this.isNeedUpdate(tableInitData)) continue;
                list.addAll(sqlProcessor.getDeInitSql(tableInitData));
            }
        }
        return list;
    }

    private List<String> getDeInitSql(InitData tableInitData, String language) {
        ArrayList<String> sqls = new ArrayList<String>();
        InitDataSqlProcessor sqlProcessor = (InitDataSqlProcessor)this.processorManager.getProcessor(language, "initData");
        sqls.addAll(sqlProcessor.getDeInitSql(tableInitData));
        return sqls;
    }

    @Override
    public List<String> getDeInitSqlByTableId(String tableId, String language) {
        List<InitData> dataList = this.getInitDataListByTableId(tableId);
        ArrayList<String> sqls = new ArrayList<String>();
        for (InitData initData : dataList) {
            sqls.addAll(this.getDeInitSql(initData, language));
        }
        return sqls;
    }

    @Override
    public List<InitData> getInitDatas() {
        ArrayList<InitData> initDataList = new ArrayList<InitData>();
        for (List<InitData> tbInitDataList : this.initDatasIdMap.values()) {
            initDataList.addAll(tbInitDataList);
        }
        return initDataList;
    }

    @Override
    public void registerModifiedTime(InitDatas initDatas, long lastModify) {
        for (InitData initData : initDatas.getInitDataList()) {
            this.initDataModifiedTimeMap.put(initData.getId(), lastModify);
        }
    }
}

