/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.initdata.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.database.config.initdata.InitData;
import org.tinygroup.database.config.initdata.Record;
import org.tinygroup.database.config.initdata.ValuePair;
import org.tinygroup.database.config.table.Table;
import org.tinygroup.database.config.table.TableField;
import org.tinygroup.database.initdata.InitDataSqlProcessor;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.metadata.config.stdfield.StandardField;
import org.tinygroup.metadata.util.MetadataUtil;

public class InitDataSqlProcessorImpl
implements InitDataSqlProcessor {
    private Logger logger = LoggerFactory.getLogger(InitDataSqlProcessorImpl.class);

    @Override
    public List<String> getInitSql(InitData initData) {
        ArrayList<String> initSqlList = new ArrayList<String>();
        Table table = DataBaseUtil.getTableById(initData.getTableId(), this.getClass().getClassLoader());
        if (initData.getRecordList() != null) {
            for (Record record : initData.getRecordList()) {
                String sql = this.valuePairsToAddString(record, table);
                if ("".equals(sql)) continue;
                this.logger.logMessage(LogLevel.DEBUG, "\u6dfb\u52a0sql:{0}", new Object[]{sql});
                if (initSqlList.contains(sql)) continue;
                initSqlList.add(sql);
            }
        }
        return initSqlList;
    }

    private String valuePairsToAddString(Record record, Table table) {
        List<String> pks = this.getPrimaryKeys(table);
        List<ValuePair> valuePairs = record.getValuePairs();
        ArrayList<String> autoIncreaseField = new ArrayList<String>();
        for (TableField tableField : table.getFieldList()) {
            if (!tableField.isAutoIncrease()) continue;
            autoIncreaseField.add(tableField.getId());
        }
        if (valuePairs == null || valuePairs.size() == 0) {
            return "";
        }
        StringBuffer keys = new StringBuffer();
        StringBuffer values = new StringBuffer();
        for (ValuePair valuePair : valuePairs) {
            if (StringUtil.isBlank((String)valuePair.getValue())) continue;
            StandardField standField = DataBaseUtil.getStandardField(valuePair.getTableFieldId(), table, this.getClass().getClassLoader());
            String standFieldName = DataBaseUtil.getDataBaseName(standField.getName());
            String value = valuePair.getValue();
            keys = keys.append(",").append(standFieldName);
            values = values.append(",").append(value);
        }
        if (keys.length() == 0) {
            return "";
        }
        return String.format("INSERT INTO %s (%s) VALUES (%s)", table.getNameWithOutSchema(), keys.substring(1), values.substring(1));
    }

    @Override
    public List<String> getDeInitSql(InitData initData) {
        ArrayList<String> initSqlList = new ArrayList<String>();
        Table table = DataBaseUtil.getTableById(initData.getTableId(), this.getClass().getClassLoader());
        List<String> pks = this.getPrimaryKeys(table);
        if (initData.getRecordList() != null) {
            for (Record record : initData.getRecordList()) {
                String sql = this.valuePairsToDelString(record, table, pks);
                if ("".equals(sql)) continue;
                this.logger.logMessage(LogLevel.DEBUG, "\u6dfb\u52a0sql:{0}", new Object[]{sql});
                if (initSqlList.contains(sql)) continue;
                initSqlList.add(sql);
            }
        }
        return initSqlList;
    }

    @Override
    public List<String> getPreInitSql(List<Table> tableList) {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getPostInitSql(List<Table> tableList) throws SQLException {
        return new ArrayList<String>();
    }

    private List<String> getPrimaryKeys(Table table) {
        ArrayList<String> keys = new ArrayList<String>();
        for (TableField field : table.getFieldList()) {
            if (!field.getPrimary()) continue;
            StandardField stdField = MetadataUtil.getStandardField((String)field.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
            keys.add(DataBaseUtil.getDataBaseName(stdField.getName()));
        }
        return keys;
    }

    protected String delimiter(String name) {
        return name;
    }

    private String valuePairsToDelString(Record record, Table table, List<String> keys) {
        List<ValuePair> valuePairs = record.getValuePairs();
        if (valuePairs == null || valuePairs.size() == 0) {
            return "";
        }
        String where = "";
        int times = 0;
        for (ValuePair valuePair : valuePairs) {
            StandardField standField = DataBaseUtil.getStandardField(valuePair.getTableFieldId(), table, this.getClass().getClassLoader());
            String standFieldName = DataBaseUtil.getDataBaseName(standField.getName());
            String value = valuePair.getValue();
            if (!keys.contains(standFieldName) || StringUtil.isBlank((String)value)) continue;
            where = where + String.format(" AND %s=%s", standFieldName, value);
            ++times;
        }
        if (times != keys.size()) {
            return "";
        }
        int index = where.indexOf("AND");
        if (StringUtil.isBlank((String)(where = where.substring(index + 3)))) {
            return "";
        }
        this.logger.logMessage(LogLevel.WARN, "\u8868{0}\u56e0\u8bbe\u7f6e\u4e3b\u952e\u503c\u800c\u751f\u6210delete\u8bed\u53e5", new Object[]{table.getName()});
        return String.format("DELETE FROM %s WHERE %s ", table.getNameWithOutSchema(), where);
    }
}

