/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.initdata.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tinygroup.database.config.table.ForeignReference;
import org.tinygroup.database.config.table.Table;
import org.tinygroup.database.config.table.TableField;
import org.tinygroup.database.initdata.impl.InitDataSqlProcessorImpl;
import org.tinygroup.database.util.DataBaseUtil;
import org.tinygroup.metadata.config.stdfield.StandardField;
import org.tinygroup.metadata.util.MetadataUtil;

public class OracleInitDataSqlProcessorImpl
extends InitDataSqlProcessorImpl {
    private static final String PROC_AUTO_INCREMENT_SQL = "CREATE OR REPLACE PROCEDURE proc_seq_to_safe(v_seqname varchar2,v_tablename varchar2,v_auto_key varchar2) as\n  cur_next number(10);\n  tsql varchar2(100);\n  db_now_max number(10);\nbegin\n  execute immediate 'select max(' || v_auto_key || ') from ' || v_tablename\n    into db_now_max;\n  execute immediate 'select ' || v_seqname || '.nextval from dual'\n      into cur_next;\n  if (db_now_max > cur_next) then\n    tsql := 'alter sequence ' || v_seqname || ' increment by ' || (db_now_max-cur_next);\n    execute immediate tsql;\n    execute immediate 'select ' || v_seqname || '.nextval from dual'\n      into cur_next;\n    tsql := 'alter sequence ' || v_seqname || ' increment by 1';\n    execute immediate tsql;\n  end if;\nEND proc_seq_to_safe;";
    private String procSql = "";

    private List<String> getPostInitSql(Table table) throws SQLException {
        ArrayList<String> postSqlList = new ArrayList<String>();
        postSqlList.addAll(this.createProcForSeq(table));
        postSqlList.addAll(this.createEnableForeignSql(table));
        return postSqlList;
    }

    @Override
    public List<String> getPostInitSql(List<Table> tableList) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        for (Table table : tableList) {
            list.addAll(this.getPostInitSql(table));
        }
        return list;
    }

    @Override
    public List<String> getPreInitSql(List<Table> tableList) {
        ArrayList<String> list = new ArrayList<String>();
        for (Table table : tableList) {
            list.addAll(this.getPreInitSql(table));
        }
        return list;
    }

    private List<String> getPreInitSql(Table table) {
        ArrayList<String> preSqlList = new ArrayList<String>();
        for (ForeignReference foreignReference : table.getForeignReferences()) {
            String baseSql = "ALTER TABLE %s DISABLE CONSTRAINT %s";
            String preSql = String.format(baseSql, this.delimiter(table.getNameWithOutSchema()), this.delimiter(foreignReference.getName()));
            preSqlList.add(preSql);
        }
        return preSqlList;
    }

    private Collection<? extends String> createEnableForeignSql(Table table) {
        ArrayList<String> preSqlList = new ArrayList<String>();
        for (ForeignReference foreignReference : table.getForeignReferences()) {
            String baseSql = "ALTER TABLE %s ENABLE CONSTRAINT %s";
            String preSql = String.format(baseSql, this.delimiter(table.getNameWithOutSchema()), this.delimiter(foreignReference.getName()));
            preSqlList.add(preSql);
        }
        return preSqlList;
    }

    private Collection<? extends String> createProcForSeq(Table table) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.procSql.length() == 0) {
            this.procSql = PROC_AUTO_INCREMENT_SQL;
            String from = DataBaseUtil.fromSourceLocal.get();
            if ("tool".equals(from)) {
                this.procSql = this.procSql + "\n/\n";
            }
            list.add(this.procSql);
        }
        String primaryValField = "";
        for (TableField field : table.getFieldList()) {
            if (!field.getPrimary() || !field.isAutoIncrease()) continue;
            StandardField stdField = MetadataUtil.getStandardField((String)field.getStandardFieldId(), (ClassLoader)this.getClass().getClassLoader());
            primaryValField = DataBaseUtil.getDataBaseName(stdField.getName());
            break;
        }
        if (primaryValField.length() > 0) {
            String seqName = "SEQ_" + table.getNameWithOutSchema().toUpperCase();
            list.add(String.format("CALL proc_seq_to_safe('%s','%s','%s')", seqName, table.getNameWithOutSchema().toUpperCase(), primaryValField.toUpperCase()));
        }
        return list;
    }
}

