/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.procedure.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.database.ProcessorManager;
import org.tinygroup.database.config.procedure.Procedure;
import org.tinygroup.database.config.procedure.Procedures;
import org.tinygroup.database.exception.DatabaseRuntimeException;
import org.tinygroup.database.procedure.ProcedureProcessor;
import org.tinygroup.database.procedure.ProcedureSqlProcessor;

public class ProcedureProcessorImpl
implements ProcedureProcessor {
    private static ProcedureProcessor procedureProcessor = new ProcedureProcessorImpl();
    Map<String, Procedure> idMap = new HashMap<String, Procedure>();
    ProcessorManager processorManager;

    public static ProcedureProcessor getProcedureProcessor() {
        return procedureProcessor;
    }

    @Override
    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    @Override
    public void setProcessorManager(ProcessorManager processorManager) {
        this.processorManager = processorManager;
    }

    @Override
    public Procedure getProcedure(String procedureId) {
        return this.idMap.get(procedureId);
    }

    @Override
    public String getCreateSql(String procedureId, String language) {
        Procedure procedure = this.getProcedure(procedureId);
        if (procedure == null) {
            throw new RuntimeException(String.format("\u8fc7\u7a0b[name:%s]\u4e0d\u5b58\u5728,", procedureId));
        }
        return this.getCreateSql(procedure, language);
    }

    @Override
    public List<String> getCreateSql(String language) {
        ArrayList<String> list = new ArrayList<String>();
        for (Procedure procedure : this.idMap.values()) {
            String createSql = this.getCreateSql(procedure, language);
            if (StringUtil.isEmpty((String)createSql)) continue;
            list.add(this.getCreateSql(procedure, language));
        }
        return list;
    }

    private String getCreateSql(Procedure procedure, String language) {
        ProcedureSqlProcessor sqlProcessor = (ProcedureSqlProcessor)this.processorManager.getProcessor(language, "procedure");
        return sqlProcessor.getCreateSql(procedure);
    }

    @Override
    public void addProcedures(Procedures procedures) {
        for (Procedure procedure : procedures.getProcedureList()) {
            if (this.idMap.containsKey(procedure.getName())) {
                throw new DatabaseRuntimeException("0TE120055005", procedure.getId());
            }
            this.idMap.put(procedure.getId(), procedure);
        }
    }

    @Override
    public void removeProcedures(Procedures procedures) {
        for (Procedure procedure : procedures.getProcedureList()) {
            this.idMap.remove(procedure.getId());
        }
    }

    @Override
    public String getDropSql(String procedureId, String language) {
        Procedure procedure = this.getProcedure(procedureId);
        if (procedure == null) {
            throw new RuntimeException(String.format("\u8fc7\u7a0b[id:%s]\u4e0d\u5b58\u5728,", procedureId));
        }
        return this.getDropSql(procedure, language);
    }

    @Override
    public List<String> getDropSql(String language) {
        ArrayList<String> list = new ArrayList<String>();
        for (Procedure procedure : this.idMap.values()) {
            list.add(this.getDropSql(procedure, language));
        }
        return list;
    }

    private String getDropSql(Procedure procedure, String language) {
        ProcedureSqlProcessor sqlProcessor = (ProcedureSqlProcessor)this.processorManager.getProcessor(language, "procedure");
        return sqlProcessor.getDropSql(procedure);
    }
}

