/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.procedure.impl;

import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.database.config.SqlBody;
import org.tinygroup.database.config.procedure.Procedure;
import org.tinygroup.database.procedure.ProcedureSqlProcessor;
import org.tinygroup.database.util.DataBaseUtil;

public abstract class ProcedureSqlProcessorImpl
implements ProcedureSqlProcessor {
    protected abstract String getDatabaseType();

    @Override
    public String getCreateSql(Procedure procedure) {
        String finalSql;
        StringBuffer sb = new StringBuffer();
        String defaultContent = "";
        String dialectContent = null;
        for (SqlBody sql : procedure.getProcedureBodyList()) {
            if ("default".equals(sql.getDialectTypeName())) {
                defaultContent = sql.getContent();
                continue;
            }
            if (!this.getDatabaseType().equals(sql.getDialectTypeName())) continue;
            dialectContent = sql.getContent();
            break;
        }
        if (!StringUtil.isEmpty((String)(finalSql = dialectContent != null ? dialectContent : defaultContent))) {
            sb.append(finalSql);
        }
        String from = DataBaseUtil.fromSourceLocal.get();
        if (sb.length() > 0 && from != null && from.equals("tool")) {
            sb.append("\n/\n");
        }
        return sb.toString();
    }

    private void appendHead(StringBuffer sb, Procedure procedure) {
        sb.append("CREATE OR REPLACE PROCEDURE ");
        sb.append(procedure.getName());
    }

    @Override
    public String getDropSql(Procedure procedure) {
        return "DROP PROCEDURE " + procedure.getName() + ";";
    }
}

