/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.sequence.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.database.ProcessorManager;
import org.tinygroup.database.config.sequence.Sequence;
import org.tinygroup.database.config.sequence.Sequences;
import org.tinygroup.database.sequence.SequenceProcessor;
import org.tinygroup.database.sequence.SequenceSqlProcessor;

public class SequenceProcessorImpl
implements SequenceProcessor {
    private static SequenceProcessor sequenceProcessor = new SequenceProcessorImpl();
    private Map<String, Sequence> sequenceMap = new HashMap<String, Sequence>();
    private ProcessorManager processorManager;

    public static SequenceProcessor getSequenceProcessor() {
        return sequenceProcessor;
    }

    @Override
    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    @Override
    public void setProcessorManager(ProcessorManager processorManager) {
        this.processorManager = processorManager;
    }

    @Override
    public void addSequences(Sequences sequences) {
        for (Sequence sequence : sequences.getSequences()) {
            this.sequenceMap.put(sequence.getName(), sequence);
        }
    }

    @Override
    public void removeSequences(Sequences sequences) {
        for (Sequence sequence : sequences.getSequences()) {
            this.sequenceMap.remove(sequence.getName());
        }
    }

    @Override
    public Sequence getSequence(String sequenceName) {
        return this.sequenceMap.get(sequenceName);
    }

    @Override
    public String getCreateSql(String sequenceName, String language) {
        Sequence sequence = this.getSequence(sequenceName);
        if (sequence == null) {
            throw new RuntimeException(String.format("sequence[name:%s]\u4e0d\u5b58\u5728,", sequenceName));
        }
        return this.getCreateSql(sequence, language);
    }

    private String getCreateSql(Sequence sequence, String language) {
        SequenceSqlProcessor sqlProcessor = (SequenceSqlProcessor)this.processorManager.getProcessor(language, "sequence");
        return sqlProcessor.getCreateSql(sequence);
    }

    @Override
    public String getDropSql(String sequenceName, String language) {
        Sequence sequence = this.getSequence(sequenceName);
        if (sequence == null) {
            throw new RuntimeException(String.format("sequence[name:%s]\u4e0d\u5b58\u5728,", sequenceName));
        }
        return this.getDropSql(sequence, language);
    }

    private String getDropSql(Sequence sequence, String language) {
        SequenceSqlProcessor sqlProcessor = (SequenceSqlProcessor)this.processorManager.getProcessor(language, "sequence");
        return sqlProcessor.getDropSql(sequence);
    }

    @Override
    public List<String> getCreateSql(String language) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (Sequence sequence : this.sequenceMap.values()) {
            sqls.add(this.getCreateSql(sequence, language));
        }
        return sqls;
    }

    @Override
    public List<String> getDropSql(String language) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (Sequence sequence : this.sequenceMap.values()) {
            sqls.add(this.getDropSql(sequence, language));
        }
        return sqls;
    }

    @Override
    public List<Sequence> getSequences(String language) {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        sequences.addAll(this.sequenceMap.values());
        return sequences;
    }

    @Override
    public boolean checkSequenceExist(String language, Sequence sequence, Connection connection) throws SQLException {
        SequenceSqlProcessor sqlProcessor = (SequenceSqlProcessor)this.processorManager.getProcessor(language, "sequence");
        return sqlProcessor.checkSequenceExist(sequence, connection);
    }
}

