/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.table;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.tinygroup.database.config.table.ForeignReference;
import org.tinygroup.database.config.table.Table;

public class TableSort
implements Comparator<Table> {
    @Override
    public int compare(Table table1, Table table2) {
        List<String> dependTables1 = this.getDependList(table1);
        List<String> dependTables2 = this.getDependList(table2);
        if (dependTables1.size() > 0 && dependTables2.size() == 0) {
            return 1;
        }
        boolean contains1 = dependTables1.contains(table2.getId());
        boolean contains2 = dependTables2.contains(table1.getId());
        if (contains1 && contains2) {
            throw new RuntimeException(String.format("\u88681[name:%s]\u4e0e\u88682[name:%s]\u76f8\u4e92\u4f9d\u8d56", table1.getName(), table2.getName()));
        }
        if (contains1) {
            return 1;
        }
        if (contains2) {
            return -1;
        }
        return 0;
    }

    private List<String> getDependList(Table table) {
        List<ForeignReference> foreigns = table.getForeignReferences();
        ArrayList<String> dependencies = new ArrayList<String>();
        for (ForeignReference foreignReference : foreigns) {
            dependencies.add(foreignReference.getMainTable());
        }
        return dependencies;
    }
}

