/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.table.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.tinygroup.database.config.table.Table;
import org.tinygroup.database.table.TableSqlProcessor;
import org.tinygroup.database.table.impl.SqlProcessorImpl;
import org.tinygroup.database.table.impl.TableProcessorImpl;

public class H2SqlProcessorImpl
extends SqlProcessorImpl {
    private static TableSqlProcessor tableSqlProcessor = new H2SqlProcessorImpl();

    public static TableSqlProcessor getTableSqlProcessor() {
        tableSqlProcessor.setTableProcessor(TableProcessorImpl.getTableProcessor());
        return tableSqlProcessor;
    }

    @Override
    protected String getDatabaseType() {
        return "h2";
    }

    @Override
    protected String createAlterTypeSql(String tableName, String fieldName, String tableDataType) {
        return String.format("ALTER TABLE %s ALTER COLUMN %s SET DATA TYPE %s", tableName, this.delimiter(fieldName), tableDataType);
    }

    @Override
    protected void appendComment(String comment, StringBuffer ddlBuffer, List<String> list) {
    }

    @Override
    protected String appendIncrease() {
        return " auto_increment ";
    }

    @Override
    protected void appendFooter(StringBuffer ddlBuffer, Table table, List<String> list) {
        super.appendFooter(ddlBuffer, table, list);
        this.appendFooterComment(table, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkTableExist(Table table, Connection connection) throws SQLException {
        ResultSet resultset = null;
        DatabaseMetaData metadata = connection.getMetaData();
        try {
            String schema = null;
            resultset = metadata.getTables(connection.getCatalog(), schema, table.getNameWithOutSchema(), new String[]{"TABLE"});
            if (resultset.next()) {
                boolean bl = true;
                return bl;
            }
            resultset.close();
            resultset = metadata.getTables(connection.getCatalog(), schema, table.getNameWithOutSchema().toUpperCase(), new String[]{"TABLE"});
            if (resultset.next()) {
                boolean bl = true;
                return bl;
            }
            if (schema != null) {
                resultset.close();
                resultset = metadata.getTables(connection.getCatalog(), schema.toUpperCase(), table.getNameWithOutSchema().toUpperCase(), new String[]{"TABLE"});
                boolean bl = resultset.next();
                return bl;
            }
        }
        finally {
            if (resultset != null) {
                resultset.close();
            }
        }
        return false;
    }

    @Override
    protected boolean checkCommentSame(String standardComment, String remarks) {
        return true;
    }

    @Override
    protected void getForeignUpdate(Table table, String packageName, Connection connection, List<String> list) throws SQLException {
    }

    @Override
    protected void getIndexUpdate(Connection connection, Table table, List<String> list) throws SQLException {
    }
}

