/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.database.table.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.tinygroup.database.config.table.Index;
import org.tinygroup.database.config.table.Table;
import org.tinygroup.database.table.TableSqlProcessor;
import org.tinygroup.database.table.impl.SqlProcessorImpl;
import org.tinygroup.database.table.impl.TableProcessorImpl;
import org.tinygroup.database.util.DataBaseUtil;

public class MysqlSqlProcessorImpl
extends SqlProcessorImpl {
    private static TableSqlProcessor tableSqlProcessor = new MysqlSqlProcessorImpl();

    public static TableSqlProcessor getTableSqlProcessor() {
        tableSqlProcessor.setTableProcessor(TableProcessorImpl.getTableProcessor());
        return tableSqlProcessor;
    }

    @Override
    protected String getDatabaseType() {
        return "mysql";
    }

    @Override
    protected String appendIncrease() {
        return " auto_increment ";
    }

    public boolean checkTableExist(Table table, String catalog, DatabaseMetaData metadata) {
        ResultSet r;
        block4: {
            boolean bl;
            r = null;
            try {
                String schema = table.getSchema();
                r = metadata.getTables(catalog, schema, table.getNameWithOutSchema(), new String[]{"TABLE"});
                if (!r.next()) break block4;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DataBaseUtil.closeResultSet(r);
                    throw throwable;
                }
            }
            DataBaseUtil.closeResultSet(r);
            return bl;
        }
        DataBaseUtil.closeResultSet(r);
        return false;
    }

    @Override
    protected String getQueryForeignSql(Table table, String schema) {
        String sql = "SELECT c.COLUMN_NAME, tc.CONSTRAINT_NAME,fc.REFERENCED_TABLE_NAME,kcu.REFERENCED_COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS c LEFT JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu ON kcu.TABLE_SCHEMA = c.TABLE_SCHEMA AND kcu.TABLE_NAME = c.TABLE_NAME AND kcu.COLUMN_NAME = c.COLUMN_NAME LEFT JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc ON tc.CONSTRAINT_SCHEMA = kcu.CONSTRAINT_SCHEMA AND tc.CONSTRAINT_NAME = kcu.CONSTRAINT_NAME LEFT JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS fc ON kcu.CONSTRAINT_SCHEMA = fc.CONSTRAINT_SCHEMA AND kcu.CONSTRAINT_NAME = fc.CONSTRAINT_NAME where tc.CONSTRAINT_TYPE='FOREIGN KEY' and c.table_name='" + table.getNameWithOutSchema() + "'";
        if (schema != null && schema.trim().length() > 0) {
            sql = sql + " and c.table_schema='" + schema + "'";
        }
        return sql;
    }

    @Override
    protected String createAlterTypeSql(String tableName, String fieldName, String tableDataType) {
        return String.format("ALTER TABLE %s CHANGE %s %s %s ", tableName, this.delimiter(fieldName), this.delimiter(fieldName), tableDataType);
    }

    @Override
    protected boolean checkTypeSame(String dbColumnType, String tableDataType, String dbDataType) {
        if (dbColumnType.startsWith("tinyint") && tableDataType.replaceAll(" ", "").toLowerCase().startsWith("tinyint")) {
            return true;
        }
        return super.checkTypeSame(dbColumnType, tableDataType, dbDataType);
    }

    @Override
    protected String getIndexName(Index index, Table table) {
        return index.getName();
    }

    @Override
    protected void appendFooterComment(Table table, List<String> list) {
    }

    @Override
    protected void getChangedFooterComment(Connection connection, Table table, List<String> list) throws SQLException {
    }

    @Override
    protected String delimiter(String name) {
        return "`" + name + "`";
    }

    @Override
    protected void appendTableSpace(StringBuffer ddlBuffer, Table table) {
    }
}

